package org.mule.weave.lsp.services.events

import org.mule.weave.lsp.services.events.AgentStartedEvent.AGENT_STARTED
import org.mule.weave.lsp.utils.InternalEvent
import org.mule.weave.lsp.utils.InternalEventHandler
import org.mule.weave.lsp.utils.InternalEventType

class AgentStartedEvent extends InternalEvent {
  override type T = OnAgentStarted

  override def getType: InternalEventType[OnAgentStarted] = AGENT_STARTED

  override def dispatch(handler: OnAgentStarted): Unit = {
    handler.onAgentStarted()
  }
}

trait OnAgentStarted extends InternalEventHandler {
  def onAgentStarted(): Unit
}

object AgentStartedEvent {
  val AGENT_STARTED = InternalEventType[OnAgentStarted]("AGENT_STARTED")
}