/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.CommandManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.InternalWeaveCommand;
import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient;
import org.mule.weave.lsp.extension.protocol.SetContextParams;
import org.mule.weave.lsp.extension.protocol.SetContextValue;
import org.mule.weave.lsp.indexer.LSPWeaveIndexService;
import org.mule.weave.lsp.project.DefaultProjectMetadata;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.events.SettingsChangedEvent;
import org.mule.weave.lsp.services.DefaultWorkspaceServiceContributor$;
import org.mule.weave.lsp.services.WorkspaceServiceContributor;
import org.mule.weave.lsp.services.events.DocumentChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent$;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent$;
import org.mule.weave.lsp.services.events.FileChangedEvent;
import org.mule.weave.lsp.services.events.OnDocumentChanged;
import org.mule.weave.lsp.services.events.OnDocumentFocused;
import org.mule.weave.lsp.services.events.OnDocumentOpened;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.indexing.IdentifierType$;
import org.mule.weave.v2.editor.indexing.LocatedResult;
import org.mule.weave.v2.editor.indexing.WeaveIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\t\u0013\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\"\u00020\u0001\t\u0003y\u0006b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007]\u0002\u0001\u000b\u0011\u00025\t\u000b=\u0004A\u0011\u00029\t\u000by\u0004A\u0011I@\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011Q\u000b\u0001\u0005B\u0005]s!CA1%\u0005\u0005\t\u0012AA2\r!\t\"#!A\t\u0002\u0005\u0015\u0004B\u00020\u000f\t\u0003\t9\u0007C\u0005\u0002j9\t\n\u0011\"\u0001\u0002l\t\u0011C)\u001a4bk2$xk\u001c:lgB\f7-Z*feZL7-Z\"p]R\u0014\u0018NY;u_JT!a\u0005\u000b\u0002\u0011M,'O^5dKNT!!\u0006\f\u0002\u00071\u001c\bO\u0003\u0002\u00181\u0005)q/Z1wK*\u0011\u0011DG\u0001\u0005[VdWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\n\n\u0005\u001d\u0012\"aG,pe.\u001c\b/Y2f'\u0016\u0014h/[2f\u0007>tGO]5ckR|'/A\u0006qe>TWm\u0019;LS:$\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0015\u0003\u001d\u0001(o\u001c6fGRL!AL\u0016\u0003\u0017A\u0013xN[3di.Kg\u000eZ\u0001\u0010aJ|'.Z2u\u001b\u0016$\u0018\rZ1uCB\u0011!&M\u0005\u0003e-\u0012a\u0003R3gCVdG\u000f\u0015:pU\u0016\u001cG/T3uC\u0012\fG/Y\u0001\u0014o\u0016\fg/\u001a)s_R|7m\u001c7DY&,g\u000e\u001e\t\u0003kij\u0011A\u000e\u0006\u0003oa\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003sQ\t\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005m2$a\u0006#bi\u0006<V-\u0019<f!J|Go\\2pY\u000ec\u0017.\u001a8u\u00039\u0019w.\\7b]\u0012l\u0015M\\1hKJ\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u000b\u0002\u0011\r|W.\\1oINL!AQ \u0003+\r{W.\\1oI6\u000bg.Y4feN+'O^5dK\u0006YR.Y=cKR+\u0007\u0010\u001e#pGVlWM\u001c;Ue\u0006t7\u000f\\1u_J\u00042aH#H\u0013\t1\u0005E\u0001\u0004PaRLwN\u001c\t\u0003\u0011ns!!\u0013-\u000f\u0005)+fBA&U\u001d\ta5K\u0004\u0002N%:\u0011a*U\u0007\u0002\u001f*\u0011\u0001\u000bH\u0001\u0007yI|w\u000e\u001e \n\u0003mI!!\u0007\u000e\n\u0005]A\u0012BA\u001d\u0017\u0013\t1v+A\u0002ba&T!!\u000f\f\n\u0005eS\u0016AG,fCZ,G*\u00198hk\u0006<WmU3sm\u0016\u0014()^5mI\u0016\u0014(B\u0001,X\u0013\taVL\u0001\fUKb$Hi\\2v[\u0016tG\u000f\u0016:b]Nd\u0017\r^8s\u0015\tI&,\u0001\u0004=S:LGO\u0010\u000b\u0007A\u0006\u00147\rZ3\u0011\u0005\u0015\u0002\u0001\"\u0002\u0015\u0007\u0001\u0004I\u0003\"B\u0018\u0007\u0001\u0004\u0001\u0004\"B\u001a\u0007\u0001\u0004!\u0004\"\u0002\u001f\u0007\u0001\u0004i\u0004bB\"\u0007!\u0003\u0005\r\u0001R\u0001\u0007Y><w-\u001a:\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u000e\u0002\u000bMdg\r\u000e6\n\u00055T'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002)9|G/\u001b4z\u0007>tG/\u001a=u\u0007\"\fgnZ3e)\t\tH\u000f\u0005\u0002 e&\u00111\u000f\t\u0002\u0005+:LG\u000fC\u0003v\u0013\u0001\u0007a/\u0001\u0002wMB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0007K\u0012LGo\u001c:\u000b\u0005m4\u0012A\u0001<3\u0013\ti\bPA\u0006WSJ$X/\u00197GS2,\u0017AB:z[\n|G\u000e\u0006\u0003\u0002\u0002\u0005}\u0002CBA\u0002\u0003#\t)\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u0017\ti!\u0001\u0003vi&d'BAA\b\u0003\u0011Q\u0017M^1\n\t\u0005M\u0011Q\u0001\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0007BA\f\u0003G\u0001b!!\u0007\u0002\u001c\u0005}QBAA\u0005\u0013\u0011\ti\"!\u0003\u0003\t1K7\u000f\u001e\t\u0005\u0003C\t\u0019\u0003\u0004\u0001\u0005\u0017\u0005\u0015\"\"!A\u0001\u0002\u000b\u0005\u0011q\u0005\u0002\u0004?\u0012\u0012\u0014\u0003BA\u0015\u0003_\u00012aHA\u0016\u0013\r\ti\u0003\t\u0002\b\u001d>$\b.\u001b8h!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tQ\u0001\\:qi)T1!!\u000f\u001b\u0003\u001d)7\r\\5qg\u0016LA!!\u0010\u00024\t\t2+_7c_2LeNZ8s[\u0006$\u0018n\u001c8\t\u000f\u0005\u0005#\u00021\u0001\u0002D\u00051\u0001/\u0019:b[N\u0004B!!\r\u0002F%!\u0011qIA\u001a\u0005U9vN]6ta\u0006\u001cWmU=nE>d\u0007+\u0019:b[N\fa\u0003Z5e\u0007\"\fgnZ3D_:4\u0017nZ;sCRLwN\u001c\u000b\u0004c\u00065\u0003bBA!\u0017\u0001\u0007\u0011q\n\t\u0005\u0003c\t\t&\u0003\u0003\u0002T\u0005M\"\u0001\b#jI\u000eC\u0017M\\4f\u0007>tg-[4ve\u0006$\u0018n\u001c8QCJ\fWn]\u0001\u0016I&$7\t[1oO\u0016<\u0016\r^2iK\u00124\u0015\u000e\\3t)\r\t\u0018\u0011\f\u0005\b\u0003\u0003b\u0001\u0019AA.!\u0011\t\t$!\u0018\n\t\u0005}\u00131\u0007\u0002\u001c\t&$7\t[1oO\u0016<\u0016\r^2iK\u00124\u0015\u000e\\3t!\u0006\u0014\u0018-\\:\u0002E\u0011+g-Y;mi^{'o[:qC\u000e,7+\u001a:wS\u000e,7i\u001c8ue&\u0014W\u000f^8s!\t)cb\u0005\u0002\u000f=Q\u0011\u00111M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u00055$f\u0001#\u0002p-\u0012\u0011\u0011\u000f\t\u0005\u0003g\ni(\u0004\u0002\u0002v)!\u0011qOA=\u0003%)hn\u00195fG.,GMC\u0002\u0002|\u0001\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty(!\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DefaultWorkspaceServiceContributor
implements WorkspaceServiceContributor {
    private final ProjectKind projectKind;
    private final DefaultProjectMetadata projectMetadata;
    private final DataWeaveProtocolClient weaveProtocolClient;
    private final CommandManagerService commandManager;
    private final Option<WeaveLanguageServerBuilder.TextDocumentTranslator> maybeTextDocumentTranslator;
    private final Logger logger;

    public static Option<WeaveLanguageServerBuilder.TextDocumentTranslator> $lessinit$greater$default$5() {
        return DefaultWorkspaceServiceContributor$.MODULE$.$lessinit$greater$default$5();
    }

    private Logger logger() {
        return this.logger;
    }

    public void org$mule$weave$lsp$services$DefaultWorkspaceServiceContributor$$notifyContextChanged(VirtualFile vf) {
        String uri = (String)this.maybeTextDocumentTranslator.map((Function1 & Serializable & scala.Serializable)translator -> translator.translate(vf.url())).getOrElse((Function0 & Serializable & scala.Serializable)() -> vf.url());
        SetContextValue[] values = (SetContextValue[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.commandManager.commands())).map((Function1 & Serializable & scala.Serializable)command -> {
            boolean bl;
            WeaveCommand weaveCommand = command;
            if (weaveCommand instanceof InternalWeaveCommand) {
                InternalWeaveCommand internalWeaveCommand = (InternalWeaveCommand)weaveCommand;
                bl = internalWeaveCommand.enabled(uri);
            } else {
                bl = true;
            }
            boolean isEnabled = bl;
            return new SetContextValue(new StringBuilder(0).append(command.commandId()).append(Commands$.MODULE$.COMMAND_ENABLED_SUFFIX()).toString(), isEnabled, vf.url());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SetContextValue.class)));
        SetContextParams params = new SetContextParams(Arrays.asList((Object[])values));
        this.weaveProtocolClient.setContext(params);
    }

    @Override
    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveResourceResolver resourceResolver = $this.projectKind.vfs().asResourceResolver();
            Iterable<LocatedResult<WeaveIdentifier>> iterable = $this.projectKind.toolingService(LSPWeaveIndexService.class).searchSymbol(params.getQuery());
            ArrayList result = new ArrayList();
            iterable.foreach((Function1 & Serializable & scala.Serializable)lr -> {
                Option moduleResource;
                SymbolInformation information = new SymbolInformation();
                information.setName(((WeaveIdentifier)lr.value()).value());
                int n = ((WeaveIdentifier)lr.value()).idType();
                SymbolKind kind = IdentifierType$.MODULE$.FUNCTION() == n ? SymbolKind.Function : (IdentifierType$.MODULE$.VARIABLE() == n ? SymbolKind.Variable : (IdentifierType$.MODULE$.NAMESPACE() == n ? SymbolKind.Namespace : (IdentifierType$.MODULE$.ANNOTATION() == n ? SymbolKind.Interface : SymbolKind.Field)));
                information.setKind(kind);
                NameIdentifier name = lr.moduleName();
                Option option = moduleResource = resourceResolver.resolve(name);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WeaveResource weaveResource = (WeaveResource)some.value();
                    Range range = new Range();
                    Position startPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).startLocation());
                    Position endPosition = weaveResource.positionOf(((WeaveIdentifier)lr.value()).endLocation());
                    range.setStart(LSPConverters$.MODULE$.toPosition(startPosition));
                    range.setEnd(LSPConverters$.MODULE$.toPosition(endPosition));
                    Location location = new Location(weaveResource.url(), range);
                    information.setLocation(location);
                    return BoxesRunTime.boxToBoolean((boolean)result.add(information));
                }
                return BoxedUnit.UNIT;
            });
            return result;
        });
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        String[] modified = this.projectMetadata.settings().update(params.getSettings());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])modified)).nonEmpty()) {
            this.projectKind.eventBus().fire(new SettingsChangedEvent(modified));
            return;
        }
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        params.getChanges().forEach(fe -> {
            if ($this.projectKind.isProjectFile(fe.getUri())) {
                this.logger().debug(new StringBuilder(26).append("Changed Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
                $this.projectKind.eventBus().fire(new FileChangedEvent(fe.getUri(), fe.getType()));
                return;
            }
            this.logger().debug(new StringBuilder(26).append("Ignored Watched File : ").append(fe.getUri()).append(" - ").append(fe.getType()).toString());
        });
    }

    public DefaultWorkspaceServiceContributor(ProjectKind projectKind, DefaultProjectMetadata projectMetadata, DataWeaveProtocolClient weaveProtocolClient, CommandManagerService commandManager, Option<WeaveLanguageServerBuilder.TextDocumentTranslator> maybeTextDocumentTranslator) {
        this.projectKind = projectKind;
        this.projectMetadata = projectMetadata;
        this.weaveProtocolClient = weaveProtocolClient;
        this.commandManager = commandManager;
        this.maybeTextDocumentTranslator = maybeTextDocumentTranslator;
        this.logger = LoggerFactory.getLogger(this.getClass());
        projectKind.eventBus().register(DocumentChangedEvent$.MODULE$.DOCUMENT_CHANGED(), new OnDocumentChanged(this){
            private final /* synthetic */ DefaultWorkspaceServiceContributor $outer;

            public void onDocumentChanged(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        projectKind.eventBus().register(DocumentOpenedEvent$.MODULE$.DOCUMENT_OPENED(), new OnDocumentOpened(this){
            private final /* synthetic */ DefaultWorkspaceServiceContributor $outer;

            public void onDocumentOpened(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        projectKind.eventBus().register(DocumentFocusChangedEvent$.MODULE$.DOCUMENT_FOCUS_CHANGED(), new OnDocumentFocused(this){
            private final /* synthetic */ DefaultWorkspaceServiceContributor $outer;

            public void onDocumentFocused(VirtualFile vf) {
                this.$outer.org$mule$weave$lsp$services$DefaultWorkspaceServiceContributor$$notifyContextChanged(vf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

