package org.mule.weave.lsp.commands

import org.eclipse.lsp4j.ExecuteCommandParams
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.services.UIService
import org.mule.weave.lsp.services.WorkspaceServiceManager

import scala.io.Source

class CreateMappingFileCommand(val workspaceServiceManager: WorkspaceServiceManager, val uIService: UIService) extends AbstractCreateFileCommand {

  val MAPPING_TEMPLATE: String = {
    val source = Source.fromInputStream(getClass.getClassLoader.getResourceAsStream("dw-template-mapping.dwl"), "UTF-8")
    try {
      source.mkString
    } finally {
      source.close()
    }
  }

  override def commandId(): String = Commands.DW_CREATE_MAPPING

  def getTemplate(executeCommandParams: ExecuteCommandParams, projectKind: ProjectKind): String = {
    MAPPING_TEMPLATE.replace("${syntaxVersion}", projectKind.getWeaveVersion())
  }

  def getInputLabel: String = {
    "Name Of The Mapping"
  }

  override def name(): String = "Create Mapping File."

  override def description(params: ExecuteCommandParams): String = "Creating Mapping file."

  override def getDefaultName(params: ExecuteCommandParams, projectKind: ProjectKind): String = "MyMapping.dwl"
}
