package org.mule.weave.lsp.semantic

import org.eclipse.lsp4j.SemanticTokensLegend
import java.util


/**
 * Values taken from <a href="https://code.visualstudio.com/api/language-extensions/semantic-highlight-guide#standard-token-types-and-modifiers">VSCode docs<a/>
 */
object DWSemanticTokensLegend {
  private val tokenTypes = util.Arrays.asList(
    "namespace",
    "class",
    "enum",
    "interface",
    "struct",
    "typeParameter",
    "type",
    "parameter",
    "variable",
    "property",
    "enumMember",
    "decorator",
    "event",
    "function",
    "method",
    "macro",
    "label",
    "comment",
    "string",
    "keyword",
    "number",
    "regexp",
    "operator"
  )

  private val tokenModifiers = util.Arrays.asList[String](
    "declaration",
    "definition",
    "readonly",
    "static",
    "deprecated",
    "abstract",
    "async",
    "modification",
    "documentation",
    "defaultLibrary"
  )

  val legend: SemanticTokensLegend = new SemanticTokensLegend(tokenTypes, tokenModifiers)
}
