package org.mule.weave.lsp.services

import org.mule.weave.lsp.extension.protocol.DataWeaveProtocolClient
import org.mule.weave.lsp.extension.protocol.MetricEvent
import org.mule.weave.lsp.extension.protocol.MetricProperty
import org.mule.weave.lsp.project.ProjectKind
import org.mule.weave.lsp.utils.InternalEventBus

import scala.collection.JavaConverters._

class MetricsService(weaveLanguageClient: DataWeaveProtocolClient) extends ToolingService {

  private val DW_EVENT_METADATA_ID = "mule_dx-dw_project_opened"
  private val DW_EVENT_SCHEMA_ID = "658e15d6-4289-4ad7-b2fb-5662cf1fa749"

  private var projectKind: ProjectKind = _
  private var eventBus: InternalEventBus = _

  override def initialize(projectKind: ProjectKind, eventBus: InternalEventBus): Unit = {
    this.projectKind = projectKind
    this.eventBus = eventBus
  }

  override def initialized(): Unit = {
  }

  def trackDataWeaveProjectOpened(timeTakenMillis: Long, dwProjectVersion: String, projectKind: String): Unit = {
    val name = MetricProperty("event_name", "project_opened")
    val duration = MetricProperty("event_duration", timeTakenMillis.toString)
    val version = MetricProperty("dataweave_version", dwProjectVersion)
    val kind = MetricProperty("project_kind", projectKind)
    trackMetricEvent(name, duration, version, kind)
  }

  private def trackMetricEvent(metricProperties: MetricProperty*): Unit = {
    val event = MetricEvent(DW_EVENT_METADATA_ID, DW_EVENT_SCHEMA_ID, metricProperties.asJava)
    weaveLanguageClient.trackMetricEvent(event)
  }
}
