package org.mule.weave.lsp.extension.client

import org.eclipse.lsp4j.ApplyWorkspaceEditParams
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse
import org.eclipse.lsp4j.ConfigurationParams
import org.eclipse.lsp4j.LogTraceParams
import org.eclipse.lsp4j.MessageActionItem
import org.eclipse.lsp4j.MessageParams
import org.eclipse.lsp4j.ProgressParams
import org.eclipse.lsp4j.PublishDiagnosticsParams
import org.eclipse.lsp4j.RegistrationParams
import org.eclipse.lsp4j.SetTraceParams
import org.eclipse.lsp4j.ShowDocumentParams
import org.eclipse.lsp4j.ShowDocumentResult
import org.eclipse.lsp4j.ShowMessageRequestParams
import org.eclipse.lsp4j.UnregistrationParams
import org.eclipse.lsp4j.WorkDoneProgressCreateParams
import org.eclipse.lsp4j.WorkspaceFolder
import org.eclipse.lsp4j.services.LanguageClient

import java.util
import java.util.concurrent.CompletableFuture

class LanguageClientDelegate extends LanguageClient {
  var delegate: LanguageClient = NoopWeaveLanguageClient

  override def applyEdit(params: ApplyWorkspaceEditParams): CompletableFuture[ApplyWorkspaceEditResponse] = delegate.applyEdit(params)

  override def registerCapability(params: RegistrationParams): CompletableFuture[Void] = delegate.registerCapability(params)

  override def unregisterCapability(params: UnregistrationParams): CompletableFuture[Void] = delegate.unregisterCapability(params)

  override def showDocument(params: ShowDocumentParams): CompletableFuture[ShowDocumentResult] = delegate.showDocument(params)

  override def workspaceFolders(): CompletableFuture[util.List[WorkspaceFolder]] = delegate.workspaceFolders()

  override def configuration(configurationParams: ConfigurationParams): CompletableFuture[util.List[AnyRef]] = delegate.configuration(configurationParams)

  override def createProgress(params: WorkDoneProgressCreateParams): CompletableFuture[Void] = delegate.createProgress(params)

  override def notifyProgress(params: ProgressParams): Unit = delegate.notifyProgress(params)

  override def logTrace(params: LogTraceParams): Unit = delegate.logTrace(params)

  override def setTrace(params: SetTraceParams): Unit = delegate.setTrace(params)

  override def refreshSemanticTokens(): CompletableFuture[Void] = delegate.refreshSemanticTokens()

  override def refreshCodeLenses(): CompletableFuture[Void] = delegate.refreshCodeLenses()

  override def telemetryEvent(o: Any): Unit = delegate.telemetryEvent(o)

  override def publishDiagnostics(publishDiagnosticsParams: PublishDiagnosticsParams): Unit = delegate.publishDiagnostics(publishDiagnosticsParams)

  override def showMessage(messageParams: MessageParams): Unit = delegate.showMessage(messageParams)

  override def showMessageRequest(showMessageRequestParams: ShowMessageRequestParams): CompletableFuture[MessageActionItem] = delegate.showMessageRequest(showMessageRequestParams)

  override def logMessage(messageParams: MessageParams): Unit = delegate.logMessage(messageParams)
}
