package org.mule.weave.lsp.services

import org.eclipse.lsp4j.ApplyWorkspaceEditParams
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse

import java.util.concurrent.CompletableFuture
import scala.collection.JavaConverters
import scala.collection.mutable.ArrayBuffer

class WorkspaceEditService {

  private val appliers: ArrayBuffer[WorkspaceEditApplier] = new ArrayBuffer[WorkspaceEditApplier]();
  private var defaultApplier: Option[WorkspaceEditApplier] = None

  def setDefaultApplier(editsApplier: WorkspaceEditApplier): Unit = {
    this.defaultApplier = Some(editsApplier)
  }

  def addApplier(editsApplier: WorkspaceEditApplier): Unit = {
    this.appliers.+=(editsApplier)
  }

  def removeApplier(editApplier: WorkspaceEditApplier): Unit = {
    this.appliers.-=(editApplier)
  }

  def applyEdit(params: ApplyWorkspaceEditParams): CompletableFuture[ApplyWorkspaceEditResponse] = {
    var uris: Seq[String] = null
    if (params.getEdit.getChanges != null) {
      uris = JavaConverters.asScalaSet(params.getEdit.getChanges.keySet()).toSeq
    } else {
      val textDocumentEdits = JavaConverters.iterableAsScalaIterable(params.getEdit.getDocumentChanges)
        .filter(e => e.isLeft)
        .map(e => e.getLeft.getTextDocument)
      uris = textDocumentEdits.map(t => t.getUri).toSeq
    }
    appliers.find((a) => uris.exists((s) => a.handles(s)))
      .orElse(defaultApplier)
      .map(_.applyEdit(params))
      .getOrElse(CompletableFuture.failedFuture(new RuntimeException("Unable to find an applier")))
  }
}
