/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.services;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.mule.weave.extension.api.WeaveLanguageServerBuilder;
import org.mule.weave.extension.api.filesystem.VirtualFile;
import org.mule.weave.lsp.actions.CodeActionsManagerService;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.commands.InsertDocumentationCommand$;
import org.mule.weave.lsp.commands.LSPWeaveTextDocument;
import org.mule.weave.lsp.extension.protocol.LaunchConfiguration$;
import org.mule.weave.lsp.extension.protocol.SampleInput;
import org.mule.weave.lsp.extension.services.DidFocusChangeParams;
import org.mule.weave.lsp.extension.services.WeaveTextDocumentService;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.project.components.Scenario;
import org.mule.weave.lsp.project.components.Scenario$;
import org.mule.weave.lsp.semantic.DWSemanticTokensLegend$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.TextDocumentTranslatorService;
import org.mule.weave.lsp.services.WeaveScenarioManagerService;
import org.mule.weave.lsp.services.events.DocumentChangedEvent;
import org.mule.weave.lsp.services.events.DocumentClosedEvent;
import org.mule.weave.lsp.services.events.DocumentFocusChangedEvent;
import org.mule.weave.lsp.services.events.DocumentOpenedEvent;
import org.mule.weave.lsp.services.events.DocumentSavedEvent;
import org.mule.weave.lsp.utils.LSPConverters$;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.lsp.utils.WeaveASTQueryUtils$;
import org.mule.weave.lsp.vfs.ProjectFileSystemService;
import org.mule.weave.lsp.vfs.VirtualFileAdapter$;
import org.mule.weave.v2.completion.Suggestion;
import org.mule.weave.v2.completion.SuggestionResult;
import org.mule.weave.v2.completion.SuggestionType$;
import org.mule.weave.v2.editor.AstNodeResult;
import org.mule.weave.v2.editor.Link;
import org.mule.weave.v2.editor.RegionKind$;
import org.mule.weave.v2.editor.SymbolInformation;
import org.mule.weave.v2.editor.SymbolKind$;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveTextDocument;
import org.mule.weave.v2.formatting.FormattingOptions;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode;
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.InputDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.scope.Reference;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.signature.FunctionSignatureResult;
import org.mule.weave.v2.utils.DWSemanticToken;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig;
import org.mule.weave.v2.utils.WeaveTypeEmitterConfig$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dd\u0001\u0002\u001b6\u0001\u0001C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t/\u0002\u0011\t\u0011)A\u00051\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003b\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u001d\u0001\bA1A\u0005\nEDa\u0001\u001f\u0001!\u0002\u0013\u0011\bbB=\u0001\u0005\u0004%IA\u001f\u0005\u0007}\u0002\u0001\u000b\u0011B>\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0004\u0001A\u0003%\u00111\u0001\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"a\u0007\u0001A\u0003%\u0011Q\u0003\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003;A\u0001\"a\f\u0001A\u0003%\u0011q\u0004\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"!\u0011\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u001e\u0001A\u0003%\u0011q\t\u0005\b\u0003o\u0002A\u0011IA=\u0011\u001d\t)\n\u0001C!\u0003/Cq!a)\u0001\t\u0003\n)\u000bC\u0004\u00020\u0002!\t%!-\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\"9\u0011q\u0019\u0001\u0005B\u0005%\u0007bBA\u0000\u0001\u0011\u0005#\u0011\u0001\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005KAqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003r\u0001!IAa\u001d\t\u000f\tU\u0005\u0001\"\u0011\u0003\u0018\"9!q\u0017\u0001\u0005\n\te\u0006b\u0002B{\u0001\u0011%!q\u001f\u0005\b\u0005\u007f\u0004A\u0011BB\u0001\u0011\u001d\u0019)\u0001\u0001C\u0005\u0007\u000fAqa!\u0005\u0001\t\u0013\u0019\u0019\u0002C\u0004\u0004\u001a\u0001!Iaa\u0007\t\u000f\r\u0005\u0002\u0001\"\u0011\u0004$!911\u0006\u0001\u0005B\r5\u0002bBB!\u0001\u0011\u000531\t\u0005\b\u0007?\u0002A\u0011IB1\u0011\u001d\u00199\u0007\u0001C!\u0007SBqaa\u001f\u0001\t\u0003\u0019i\bC\u0004\u0004\u0010\u0002!\te!%\t\u000f\r5\u0006\u0001\"\u0011\u00040\"91\u0011\u001d\u0001\u0005\n\r\r\bbBBv\u0001\u0011\u00053Q\u001e\u0005\b\t\u0017\u0001A\u0011\tC\u0007\u0011\u001d!\u0019\u0003\u0001C!\tKAq\u0001b\u000e\u0001\t\u0003\"I\u0004C\u0004\u0005P\u0001!I\u0001\"\u0015\u00031\u0011\u000bG/Y,fCZ,Gi\\2v[\u0016tGoU3sm&\u001cWM\u0003\u00027o\u0005A1/\u001a:wS\u000e,7O\u0003\u00029s\u0005\u0019An\u001d9\u000b\u0005iZ\u0014!B<fCZ,'B\u0001\u001f>\u0003\u0011iW\u000f\\3\u000b\u0003y\n1a\u001c:h\u0007\u0001\u00192\u0001A!J!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mC:<'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013aa\u00142kK\u000e$\bC\u0001&O\u001b\u0005Y%B\u0001\u001cM\u0015\tiu'A\u0005fqR,gn]5p]&\u0011qj\u0013\u0002\u0019/\u0016\fg/\u001a+fqR$unY;nK:$8+\u001a:wS\u000e,\u0017a\u00039s_*,7\r^&j]\u0012\u0004\"AU+\u000e\u0003MS!\u0001V\u001c\u0002\u000fA\u0014xN[3di&\u0011ak\u0015\u0002\f!J|'.Z2u\u0017&tG-\u0001\u0005fq\u0016\u001cW\u000f^8s!\tIf,D\u0001[\u0015\tYF,\u0001\u0006d_:\u001cWO\u001d:f]RT!!X#\u0002\tU$\u0018\u000e\\\u0005\u0003?j\u0013\u0001\"\u0012=fGV$xN]\u0001\u001bgV\u0004\bo\u001c:u\u0003\u0012$WK\\5u)\u0016\u001cHoQ8eK2+gn\u001d\t\u0003E\u0016l\u0011a\u0019\u0006\u0002I\u0006)1oY1mC&\u0011am\u0019\u0002\b\u0005>|G.Z1o\u0003U\u0019X\u000f\u001d9peR\u0014VO\\'baBLgn\u001a'f]N\fa\u0001P5oSRtD#\u00026m[:|\u0007CA6\u0001\u001b\u0005)\u0004\"\u0002)\u0006\u0001\u0004\t\u0006\"B,\u0006\u0001\u0004A\u0006\"\u00021\u0006\u0001\u0004\t\u0007\"B4\u0006\u0001\u0004\t\u0017A\u00027pO\u001e,'/F\u0001s!\t\u0019h/D\u0001u\u0015\t)X(A\u0003tY\u001a$$.\u0003\u0002xi\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\bu_>d\u0017N\\4TKJ4\u0018nY3t+\u0005Y\bCA6}\u0013\tiXGA\fECR\fw+Z1wKR{w\u000e\\5oON+'O^5dK\u0006\u0001Bo\\8mS:<7+\u001a:wS\u000e,7\u000fI\u0001\naJ|'.Z2u\rN+\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u00038\u0003\r1hm]\u0005\u0005\u0003\u001b\t9A\u0001\rQe>TWm\u0019;GS2,7+_:uK6\u001cVM\u001d<jG\u0016\f!\u0002\u001d:pU\u0016\u001cGOR*!\u0003A\u00198-\u001a8be&|7oU3sm&\u001cW-\u0006\u0002\u0002\u0016A\u00191.a\u0006\n\u0007\u0005eQGA\u000eXK\u00064XmU2f]\u0006\u0014\u0018n\\'b]\u0006<WM]*feZL7-Z\u0001\u0012g\u000e,g.\u0019:j_N\u001cVM\u001d<jG\u0016\u0004SCAA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\ta!\u001a3ji>\u0014(bAA\u0015s\u0005\u0011aOM\u0005\u0005\u0003[\t\u0019CA\tWSJ$X/\u00197GS2,7+_:uK6\fAA\u001e4tA\u0005I2m\u001c3f\u0003\u000e$\u0018n\u001c8t\u001b\u0006t\u0017mZ3s'\u0016\u0014h/[2f+\t\t)\u0004\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tYdN\u0001\bC\u000e$\u0018n\u001c8t\u0013\u0011\ty$!\u000f\u00033\r{G-Z!di&|gn]'b]\u0006<WM]*feZL7-Z\u0001\u001bG>$W-Q2uS>t7/T1oC\u001e,'oU3sm&\u001cW\rI\u0001\u0017i\u0016DH\u000fR8dk6,g\u000e\u001e+sC:\u001cH.\u0019;peV\u0011\u0011q\t\t\u0005\u0003\u0013\nyG\u0004\u0003\u0002L\u0005%d\u0002BA'\u0003GrA!a\u0014\u0002b9!\u0011\u0011KA0\u001d\u0011\t\u0019&!\u0018\u000f\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017@\u0003\u0019a$o\\8u}%\ta(\u0003\u0002={%\u0011!hO\u0005\u0003\u001bfJA!!\u001a\u0002h\u0005\u0019\u0011\r]5\u000b\u00055K\u0014\u0002BA6\u0003[\n!dV3bm\u0016d\u0015M\\4vC\u001e,7+\u001a:wKJ\u0014U/\u001b7eKJTA!!\u001a\u0002h%!\u0011\u0011OA:\u0005Y!V\r\u001f;E_\u000e,X.\u001a8u)J\fgn\u001d7bi>\u0014(\u0002BA6\u0003[\nq\u0003^3yi\u0012{7-^7f]R$&/\u00198tY\u0006$xN\u001d\u0011\u0002\u000f\u0011LGm\u00149f]R!\u00111PAA!\r\u0011\u0017QP\u0005\u0004\u0003\u007f\u001a'\u0001B+oSRDq!a!\u0015\u0001\u0004\t))A\u0005pa\u0016t\u0007+\u0019:b[B!\u0011qQAI\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015!\u00027taRR'bAAH{\u00059Qm\u00197jaN,\u0017\u0002BAJ\u0003\u0013\u0013\u0011\u0004R5e\u001fB,g\u000eV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u0006IA-\u001b3DQ\u0006tw-\u001a\u000b\u0005\u0003w\nI\nC\u0004\u0002\u001cV\u0001\r!!(\u0002\rA\f'/Y7t!\u0011\t9)a(\n\t\u0005\u0005\u0016\u0011\u0012\u0002\u001c\t&$7\t[1oO\u0016$V\r\u001f;E_\u000e,X.\u001a8u!\u0006\u0014\u0018-\\:\u0002\u0011\u0011LGm\u00117pg\u0016$B!a\u001f\u0002(\"9\u00111\u0014\fA\u0002\u0005%\u0006\u0003BAD\u0003WKA!!,\u0002\n\nQB)\u001b3DY>\u001cX\rV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u00069A-\u001b3TCZ,G\u0003BA>\u0003gCq!a'\u0018\u0001\u0004\t)\f\u0005\u0003\u0002\b\u0006]\u0016\u0002BA]\u0003\u0013\u0013\u0011\u0004R5e'\u00064X\rV3yi\u0012{7-^7f]R\u0004\u0016M]1ng\u0006qA-\u001b3G_\u000e,8o\u00115b]\u001e,G\u0003BA>\u0003\u007fCq!a'\u0019\u0001\u0004\t\t\rE\u0002K\u0003\u0007L1!!2L\u0005Q!\u0015\u000e\u001a$pGV\u001c8\t[1oO\u0016\u0004\u0016M]1ng\u0006Q1m\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005-\u0017Q\u001f\t\u00063\u00065\u0017\u0011[\u0005\u0004\u0003\u001fT&!E\"p[BdW\r^1cY\u00164U\u000f^;sKBA\u00111[Ao\u0003C\fy/\u0004\u0002\u0002V*!\u0011q[Am\u0003!iWm]:bO\u0016\u001c(\u0002BAn\u0003\u0013\u000bqA[:p]J\u00048-\u0003\u0003\u0002`\u0006U'AB#ji\",'\u000f\u0005\u0004\u0002d\u0006\u0015\u0018\u0011^\u0007\u00029&\u0019\u0011q\u001d/\u0003\t1K7\u000f\u001e\t\u0005\u0003\u000f\u000bY/\u0003\u0003\u0002n\u0006%%AD\"p[BdW\r^5p]&#X-\u001c\t\u0005\u0003\u000f\u000b\t0\u0003\u0003\u0002t\u0006%%AD\"p[BdW\r^5p]2K7\u000f\u001e\u0005\b\u0003oL\u0002\u0019AA}\u0003!\u0001xn]5uS>t\u0007\u0003BAD\u0003wLA!!@\u0002\n\n\u00012i\\7qY\u0016$\u0018n\u001c8QCJ\fWn]\u0001\u0013g\u0016l\u0017M\u001c;jGR{7.\u001a8t\rVdG\u000e\u0006\u0003\u0003\u0004\t-\u0001#B-\u0002N\n\u0015\u0001\u0003BAD\u0005\u000fIAA!\u0003\u0002\n\nq1+Z7b]RL7\rV8lK:\u001c\bbBAN5\u0001\u0007!Q\u0002\t\u0005\u0003\u000f\u0013y!\u0003\u0003\u0003\u0012\u0005%%\u0001F*f[\u0006tG/[2U_.,gn\u001d)be\u0006l7/A\u0013hKR\u001cVoZ4fgRLwN\\:B]\u0012\u001c%/Z1uK\u000e{W\u000e\u001d7fi&|g\u000eT5tiR1\u0011\u0011\u001bB\f\u0005CAqA!\u0007\u001c\u0001\u0004\u0011Y\"\u0001\bu_>d\u0017N\\4TKJ4\u0018nY3\u0011\t\u0005\u0005\"QD\u0005\u0005\u0005?\t\u0019CA\u000eXK\u00064X\rR8dk6,g\u000e\u001e+p_2LgnZ*feZL7-\u001a\u0005\b\u0003o\\\u0002\u0019AA}\u00035\u0019\u0018n\u001a8biV\u0014X\rS3maR!!q\u0005B\u0018!\u0015I\u0016Q\u001aB\u0015!\u0011\t9Ia\u000b\n\t\t5\u0012\u0011\u0012\u0002\u000e'&<g.\u0019;ve\u0016DU\r\u001c9\t\u000f\u0005mE\u00041\u0001\u00032A!\u0011q\u0011B\u001a\u0013\u0011\u0011)$!#\u0003'MKwM\\1ukJ,\u0007*\u001a7q!\u0006\u0014\u0018-\\:\u0002%\u001d,G/\u00138qkR$\u0015N]3di&4Xm\u001d\u000b\u0005\u0005w\u0011y\u0006\u0005\u0004\u0003>\t\r#qI\u0007\u0003\u0005\u007fQ1A!\u0011d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000b\u0012yDA\u0002TKF\u0004BA!\u0013\u0003\\5\u0011!1\n\u0006\u0005\u0005\u001b\u0012y%\u0001\u0006eSJ,7\r^5wKNTAA!\u0015\u0003T\u00051\u0001.Z1eKJTAA!\u0016\u0003X\u0005\u0019\u0011m\u001d;\u000b\t\te\u0013qE\u0001\u0007a\u0006\u00148/\u001a:\n\t\tu#1\n\u0002\u000f\u0013:\u0004X\u000f\u001e#je\u0016\u001cG/\u001b<f\u0011\u001d\u0011\t'\ba\u0001\u0005G\nA\"\\1zE\u0016\f5\u000f\u001e(pI\u0016\u0004RA\u0019B3\u0005SJ1Aa\u001ad\u0005\u0019y\u0005\u000f^5p]B!!1\u000eB7\u001b\t\u0011\u0019&\u0003\u0003\u0003p\tM#aB!ti:{G-Z\u0001\u0016GJ,\u0017\r^3NCB\u0004\u0018N\\4UKN$H*\u001a8t)\u0011\u0011)H!!\u0011\r\u0005\r(q\u000fB>\u0013\r\u0011I\b\u0018\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u0004B!a\"\u0003~%!!qPAE\u0005!\u0019u\u000eZ3MK:\u001c\bb\u0002BB=\u0001\u0007!QQ\u0001\u0004kJd\u0007\u0003\u0002BD\u0005\u001fsAA!#\u0003\fB\u0019\u0011QK2\n\u0007\t55-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005#\u0013\u0019J\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u001b\u001b\u0017\u0001C2pI\u0016dUM\\:\u0015\t\te%q\u0016\t\u00063\u00065'1\u0014\u0019\u0005\u0005;\u0013\u0019\u000b\u0005\u0004\u0002d\u0006\u0015(q\u0014\t\u0005\u0005C\u0013\u0019\u000b\u0004\u0001\u0005\u0017\t\u0015v$!A\u0001\u0002\u000b\u0005!q\u0015\u0002\u0004?\u0012\n\u0014\u0003\u0002BU\u0005w\u00022A\u0019BV\u0013\r\u0011ik\u0019\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\tYj\ba\u0001\u0005c\u0003B!a\"\u00034&!!QWAE\u00059\u0019u\u000eZ3MK:\u001c\b+\u0019:b[N\f\u0001c]1na2,G)\u0019;b\u0019\u0016t7/Z:\u0015\u0015\tU$1\u0018Bg\u0005;\u0014\t\u0010C\u0004\u0003>\u0002\u0002\rAa0\u0002\u001b5\f\u0017PY3TG\u0016t\u0017M]5p!\u0015\u0011'Q\rBa!\u0011\u0011\u0019M!3\u000e\u0005\t\u0015'b\u0001Bd'\u0006Q1m\\7q_:,g\u000e^:\n\t\t-'Q\u0019\u0002\t'\u000e,g.\u0019:j_\"9!q\u001a\u0011A\u0002\tE\u0017A\u00048b[\u0016LE-\u001a8uS\u001aLWM\u001d\t\u0005\u0005'\u0014I.\u0004\u0002\u0003V*!!q\u001bB*\u0003%1\u0018M]5bE2,7/\u0003\u0003\u0003\\\nU'A\u0004(b[\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\b\u0005?\u0004\u0003\u0019\u0001Bq\u0003=Ig\u000e];u\t&\u0014Xm\u0019;jm\u0016\u001c\bC\u0002Br\u0005[\u00149E\u0004\u0003\u0003f\n%h\u0002BA+\u0005OL\u0011\u0001Z\u0005\u0004\u0005W\u001c\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005\u000b\u0012yOC\u0002\u0003l\u000eDqAa=!\u0001\u0004\u0011))A\u0002ve&\fQ\u0002Z8d'R\f'\u000f\u001e*b]\u001e,GC\u0001B}!\u0011\t9Ia?\n\t\tu\u0018\u0011\u0012\u0002\u0006%\u0006tw-Z\u0001\u000feVtW*\u00199qS:<G*\u001a8t)\u0011\u0011Yha\u0001\t\u000f\t='\u00051\u0001\u0003R\u0006i\u0011N\u001c9vi\u001aKG.\u001a(b[\u0016$Ba!\u0003\u0004\u000eA\u0019!ia\u0003\n\u0007\tE5\tC\u0004\u0004\u0010\r\u0002\rAa\u0012\u0002\u0005%$\u0017AF1eI\u0012{7-^7f]R\fG/[8o\u0019\u0016t7/Z:\u0015\r\tU4QCB\f\u0011\u001d\u0011)\u0006\na\u0001\u0005SBqAa=%\u0001\u0004\u0011))A\tbI\u0012,f.\u001b;UKN$H*\u001a8tKN$bA!\u001e\u0004\u001e\r}\u0001b\u0002B+K\u0001\u0007!\u0011\u000e\u0005\b\u0005g,\u0003\u0019\u0001BC\u0003=\u0011Xm]8mm\u0016\u001cu\u000eZ3MK:\u001cH\u0003BB\u0013\u0007O\u0001R!WAg\u0005wBqa!\u000b'\u0001\u0004\u0011Y(\u0001\u0006v]J,7o\u001c7wK\u0012\fABZ8mI&twMU1oO\u0016$Baa\f\u0004:A)\u0011,!4\u00042A1\u00111]As\u0007g\u0001B!a\"\u00046%!1qGAE\u000511u\u000e\u001c3j]\u001e\u0014\u0016M\\4f\u0011\u001d\tYj\na\u0001\u0007w\u0001B!a\"\u0004>%!1qHAE\u0005e1u\u000e\u001c3j]\u001e\u0014\u0016M\\4f%\u0016\fX/Z:u!\u0006\u0014\u0018-\\:\u0002\u0015\r|G-Z!di&|g\u000e\u0006\u0003\u0004F\r]\u0003#B-\u0002N\u000e\u001d\u0003CBAr\u0003K\u001cI\u0005\u0005\u0005\u0002T\u0006u71JB)!\u0011\t9i!\u0014\n\t\r=\u0013\u0011\u0012\u0002\b\u0007>lW.\u00198e!\u0011\t9ia\u0015\n\t\rU\u0013\u0011\u0012\u0002\u000b\u0007>$W-Q2uS>t\u0007bBANQ\u0001\u00071\u0011\f\t\u0005\u0003\u000f\u001bY&\u0003\u0003\u0004^\u0005%%\u0001E\"pI\u0016\f5\r^5p]B\u000b'/Y7t\u0003U\u0011Xm]8mm\u0016\u001cu.\u001c9mKRLwN\\%uK6$Baa\u0019\u0004fA)\u0011,!4\u0002j\"91\u0011F\u0015A\u0002\u0005%\u0018!\u00025pm\u0016\u0014H\u0003BB6\u0007g\u0002R!WAg\u0007[\u0002B!a\"\u0004p%!1\u0011OAE\u0005\u0015AuN^3s\u0011\u001d\tYJ\u000ba\u0001\u0007k\u0002B!a\"\u0004x%!1\u0011PAE\u0005-AuN^3s!\u0006\u0014\u0018-\\:\u0002\u0019Q|7+_7c_2\\\u0015N\u001c3\u0015\t\r}4Q\u0011\t\u0005\u0003\u000f\u001b\t)\u0003\u0003\u0004\u0004\u0006%%AC*z[\n|GnS5oI\"91qQ\u0016A\u0002\r%\u0015\u0001B6j]\u0012\u00042AYBF\u0013\r\u0019ii\u0019\u0002\u0004\u0013:$\u0018A\u00043pGVlWM\u001c;Ts6\u0014w\u000e\u001c\u000b\u0005\u0007'\u001b)\u000bE\u0003Z\u0003\u001b\u001c)\n\u0005\u0004\u0002d\u0006\u00158q\u0013\t\t\u0003'\fin!'\u0004 B!\u0011qQBN\u0013\u0011\u0019i*!#\u0003#MKXNY8m\u0013:4wN]7bi&|g\u000e\u0005\u0003\u0002\b\u000e\u0005\u0016\u0002BBR\u0003\u0013\u0013a\u0002R8dk6,g\u000e^*z[\n|G\u000eC\u0004\u0002\u001c2\u0002\raa*\u0011\t\u0005\u001d5\u0011V\u0005\u0005\u0007W\u000bII\u0001\u000bE_\u000e,X.\u001a8u'fl'm\u001c7QCJ\fWn]\u0001\u000bI\u00164\u0017N\\5uS>tG\u0003BBY\u00073\u0004R!WAg\u0007g\u0003\u0002\"a5\u0002^\u000eU6q\u0019\u0019\u0005\u0007o\u001bY\f\u0005\u0004\u0002d\u0006\u00158\u0011\u0018\t\u0005\u0005C\u001bY\fB\u0006\u0004>6\n\t\u0011!A\u0003\u0002\r}&aA0%eE!!\u0011VBa!\u0011\t9ia1\n\t\r\u0015\u0017\u0011\u0012\u0002\t\u0019>\u001c\u0017\r^5p]B\"1\u0011ZBg!\u0019\t\u0019/!:\u0004LB!!\u0011UBg\t-\u0019y-LA\u0001\u0002\u0003\u0015\ta!5\u0003\u0007}#3'\u0005\u0003\u0003*\u000eM\u0007\u0003BAD\u0007+LAaa6\u0002\n\naAj\\2bi&|g\u000eT5oW\"9\u00111T\u0017A\u0002\rm\u0007\u0003BAD\u0007;LAaa8\u0002\n\n\u0001B)\u001a4j]&$\u0018n\u001c8QCJ\fWn]\u0001\u000be\u0016\u001cx\u000e\u001c<f+JdG\u0003BBs\u0007O\u0004RA\u0019B3\u0005\u000bCqa!;/\u0001\u0004\u0011\t.\u0001\u0006n_\u0012,H.\u001a(b[\u0016\f!BZ8s[\u0006$H/\u001b8h)\u0011\u0019y\u000fb\u0001\u0011\u000be\u000bim!=1\t\rM8q\u001f\t\u0007\u0003G\f)o!>\u0011\t\t\u00056q\u001f\u0003\f\u0007s|\u0013\u0011!A\u0001\u0006\u0003\u0019YPA\u0002`IQ\nBA!+\u0004~B!\u0011qQB\u0000\u0013\u0011!\t!!#\u0003\u0011Q+\u0007\u0010^#eSRDq!a'0\u0001\u0004!)\u0001\u0005\u0003\u0002\b\u0012\u001d\u0011\u0002\u0002C\u0005\u0003\u0013\u0013\u0001\u0004R8dk6,g\u000e\u001e$pe6\fG\u000f^5oOB\u000b'/Y7t\u0003=\u0011\u0018M\\4f\r>\u0014X.\u0019;uS:<G\u0003\u0002C\b\t7\u0001R!WAg\t#\u0001D\u0001b\u0005\u0005\u0018A1\u00111]As\t+\u0001BA!)\u0005\u0018\u0011YA\u0011\u0004\u0019\u0002\u0002\u0003\u0005)\u0011AB~\u0005\ryF%\u000e\u0005\b\u00037\u0003\u0004\u0019\u0001C\u000f!\u0011\t9\tb\b\n\t\u0011\u0005\u0012\u0011\u0012\u0002\u001e\t>\u001cW/\\3oiJ\u000bgnZ3G_Jl\u0017\r\u001e;j]\u001e\u0004\u0016M]1ng\u00061!/\u001a8b[\u0016$B\u0001b\n\u00050A)\u0011,!4\u0005*A!\u0011q\u0011C\u0016\u0013\u0011!i#!#\u0003\u001b]{'o[:qC\u000e,W\tZ5u\u0011\u001d\tY*\ra\u0001\tc\u0001B!a\"\u00054%!AQGAE\u00051\u0011VM\\1nKB\u000b'/Y7t\u0003)\u0011XMZ3sK:\u001cWm\u001d\u000b\u0005\tw!9\u0005E\u0003Z\u0003\u001b$i\u0004\r\u0003\u0005@\u0011\r\u0003CBAr\u0003K$\t\u0005\u0005\u0003\u0003\"\u0012\rCa\u0003C#e\u0005\u0005\t\u0011!B\u0001\u0007\u007f\u00131a\u0018\u00137\u0011\u001d\tYJ\ra\u0001\t\u0013\u0002B!a\"\u0005L%!AQJAE\u0005=\u0011VMZ3sK:\u001cW\rU1sC6\u001c\u0018!E4fi\u000e{W\u000e\u001d7fi&|g\u000eV=qKR!A1\u000bC-!\u0011\t9\t\"\u0016\n\t\u0011]\u0013\u0011\u0012\u0002\u0013\u0007>l\u0007\u000f\\3uS>t\u0017\n^3n\u0017&tG\rC\u0004\u0005\\M\u0002\r\u0001\"\u0018\u0002\u0007M,x\r\u0005\u0003\u0005`\u0011\rTB\u0001C1\u0015\u0011\t9-a\n\n\t\u0011\u0015D\u0011\r\u0002\u000b'V<w-Z:uS>t\u0007")
public class DataWeaveDocumentService
implements WeaveTextDocumentService {
    private final ProjectKind projectKind;
    private final Executor executor;
    private final boolean supportAddUnitTestCodeLens;
    private final boolean supportRunMappingLens;
    private final Logger logger;
    private final DataWeaveToolingService toolingServices;
    private final ProjectFileSystemService projectFS;
    private final WeaveScenarioManagerService scenariosService;
    private final VirtualFileSystem vfs;
    private final CodeActionsManagerService codeActionsManagerService;
    private final WeaveLanguageServerBuilder.TextDocumentTranslator textDocumentTranslator;

    private Logger logger() {
        return this.logger;
    }

    private DataWeaveToolingService toolingServices() {
        return this.toolingServices;
    }

    private ProjectFileSystemService projectFS() {
        return this.projectFS;
    }

    private WeaveScenarioManagerService scenariosService() {
        return this.scenariosService;
    }

    private VirtualFileSystem vfs() {
        return this.vfs;
    }

    private CodeActionsManagerService codeActionsManagerService() {
        return this.codeActionsManagerService;
    }

    private WeaveLanguageServerBuilder.TextDocumentTranslator textDocumentTranslator() {
        return this.textDocumentTranslator;
    }

    public void didOpen(DidOpenTextDocumentParams openParam) {
        TextDocumentItem textDocument = openParam.getTextDocument();
        String uri = textDocument.getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().update(uri, openParam.getTextDocument().getText());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentOpenedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentOpenedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        VersionedTextDocumentIdentifier textDocument = params.getTextDocument();
        String uri = textDocument.getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().update(uri, ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile;
        String uri = params.getTextDocument().getUri();
        this.toolingServices().closeDocument(uri);
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile = this.projectFS().closed(uri);
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentClosedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentClosedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        Option<org.mule.weave.v2.editor.VirtualFile> maybeVirtualFile = this.projectFS().saved(params.getTextDocument().getUri());
        Option<org.mule.weave.v2.editor.VirtualFile> option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentSavedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentSavedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void didFocusChange(DidFocusChangeParams params) {
        String uri = params.textDocumentIdentifier().getUri();
        Option maybeVirtualFile = Option$.MODULE$.apply((Object)this.projectFS().file(uri));
        Option option = maybeVirtualFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.mule.weave.v2.editor.VirtualFile value = (org.mule.weave.v2.editor.VirtualFile)some.value();
            this.projectKind.eventBus().fire(new DocumentFocusChangedEvent(value));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            org.mule.weave.v2.editor.VirtualFile virtualFile = this.vfs().file(uri);
            if (virtualFile != null) {
                this.projectKind.eventBus().fire(new DocumentFocusChangedEvent(virtualFile));
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public CompletableFuture<Either<java.util.List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(position.getTextDocument().getUri());
            return this.getSuggestionsAndCreateCompletionList(toolingService, position);
        }, this.executor);
    }

    public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
        WeaveDocumentToolingService weaveDocumentToolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
        DWSemanticToken[] dwTokens = weaveDocumentToolingService.semanticTokens();
        Integer[] tokenData = new Integer[5 * dwTokens.length];
        ObjectRef lastPosition = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dwTokens)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            DWSemanticToken token = dwTokens[i];
            Position startPosition = LSPConverters$.MODULE$.toPosition(token.location().startPosition());
            if (i == 0) {
                tokenData$1[0] = Predef$.MODULE$.int2Integer(startPosition.getLine());
                tokenData$1[1] = Predef$.MODULE$.int2Integer(startPosition.getCharacter());
                tokenData$1[2] = Predef$.MODULE$.int2Integer(token.location().length());
            } else {
                int deltaLine = startPosition.getLine() - ((Position)lastPosition$1.elem).getLine();
                tokenData$1[5 * i] = Predef$.MODULE$.int2Integer(deltaLine);
                tokenData$1[5 * i + 1] = deltaLine == 0 ? Predef$.MODULE$.int2Integer(startPosition.getCharacter() - ((Position)lastPosition$1.elem).getCharacter()) : Predef$.MODULE$.int2Integer(startPosition.getCharacter());
                tokenData$1[5 * i + 2] = Predef$.MODULE$.int2Integer(token.location().length());
            }
            int encodedType = DWSemanticTokensLegend$.MODULE$.legend().getTokenTypes().indexOf(token.tokenType());
            tokenData$1[5 * i + 3] = Predef$.MODULE$.int2Integer(encodedType);
            IntRef encodedModifiers = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])token.tokenModifiers())).foreach((Function1 & Serializable & scala.Serializable)attr -> {
                DataWeaveDocumentService.$anonfun$semanticTokensFull$2(encodedModifiers, attr);
                return BoxedUnit.UNIT;
            });
            tokenData$1[5 * i + 4] = Predef$.MODULE$.int2Integer(encodedModifiers.elem);
            lastPosition$1.elem = startPosition;
        });
        return CompletableFuture.supplyAsync(() -> new SemanticTokens(JavaConverters$.MODULE$.seqAsJavaList(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokenData)).toSeq())));
    }

    private Either<java.util.List<CompletionItem>, CompletionList> getSuggestionsAndCreateCompletionList(WeaveDocumentToolingService toolingService, CompletionParams position) {
        int offset = toolingService.offsetOf(position.getPosition().getLine(), position.getPosition().getCharacter());
        SuggestionResult suggestionResult = toolingService.completion(offset);
        ArrayList result = new ArrayList();
        IntRef i = IntRef.create((int)0);
        Suggestion[] suggestions = suggestionResult.suggestions();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])suggestions)).foreach((Function1 & Serializable & scala.Serializable)sug -> {
            DataWeaveDocumentService.$anonfun$getSuggestionsAndCreateCompletionList$1(this, i, suggestionResult, toolingService, result, sug);
            return BoxedUnit.UNIT;
        });
        return Either.forRight((Object)new CompletionList(false, result));
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        return CompletableFuture.supplyAsync(() -> {
            Position position;
            int offset;
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            Option maybeResult = toolingService.signatureInfo(offset = toolingService.offsetOf((position = params.getPosition()).getLine(), position.getCharacter()));
            Option option = maybeResult;
            if (option instanceof Some) {
                Some some = (Some)option;
                FunctionSignatureResult signatureResult = (FunctionSignatureResult)some.value();
                SignatureInformation[] signatures = (SignatureInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).map((Function1 & Serializable & scala.Serializable)s -> {
                    ParameterInformation[] informations = (ParameterInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.parameters())).map((Function1 & Serializable & scala.Serializable)p -> new ParameterInformation(new StringBuilder(2).append(p.name()).append(": ").append(p.wtype().toString()).toString(), ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParameterInformation.class)));
                    MarkupContent documentation = (MarkupContent)s.docAsMarkdown().map((Function1 & Serializable & scala.Serializable)d -> new MarkupContent("markdown", d)).orNull(Predef$.MODULE$.$conforms());
                    String arguments = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])informations)).map((Function1 & Serializable & scala.Serializable)i -> (String)i.getLabel().getLeft(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                    return new SignatureInformation(new StringBuilder(2).append(signatureResult.name()).append("(").append(arguments).append(")").toString(), documentation, Arrays.asList((Object[])informations));
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SignatureInformation.class)));
                int i = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])signatureResult.signatures())).indexWhere((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.active()));
                return new SignatureHelp(Arrays.asList((Object[])signatures), Predef$.MODULE$.int2Integer(i), Predef$.MODULE$.int2Integer(signatureResult.currentArgIndex()));
            }
            if (None$.MODULE$.equals(option)) {
                return new SignatureHelp();
            }
            throw new MatchError((Object)option);
        });
    }

    private Seq<InputDirective> getInputDirectives(Option<AstNode> maybeAstNode) {
        return (Seq)maybeAstNode.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends AstNode, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DocumentNode) {
                    DocumentNode documentNode = (DocumentNode)A1;
                    return (B1)documentNode;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(AstNode x1) {
                AstNode astNode = x1;
                return astNode instanceof DocumentNode;
            }
        }).map((Function1 & Serializable & scala.Serializable)documentNode -> (Seq)AstNodeHelper$.MODULE$.getInputs(documentNode).filter((Function1 & Serializable & scala.Serializable)inputDirective -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$getInputDirectives$3(inputDirective)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private ArrayList<CodeLens> createMappingTestLens(String url) {
        Object object;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        Option<File> maybeFile = ProjectStructureHelper$.MODULE$.defaultTestSourceFolder(this.projectKind.structure());
        if (maybeFile.isDefined()) {
            Command command = new Command("Create Integration Mapping", Commands$.MODULE$.DW_CREATE_TEST_MAPPING(), Arrays.asList(URLUtils$.MODULE$.toLSPUrl((File)maybeFile.get()), url));
            object = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
        } else {
            object = BoxedUnit.UNIT;
        }
        return lenses;
    }

    public CompletableFuture<java.util.List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return CompletableFuture.supplyAsync(() -> DataWeaveDocumentService.$anonfun$codeLens$1(this, params));
    }

    private ArrayList<CodeLens> sampleDataLenses(Option<Scenario> maybeScenario, NameIdentifier nameIdentifier, Seq<InputDirective> inputDirectives, String uri) {
        Object object;
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        if (maybeScenario.isEmpty()) {
            Object object2;
            if (inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_SCENARIO(), Arrays.asList(nameIdentifier.name(), uri, Scenario$.MODULE$.PLAYGROUND_SCENARIO()));
                object2 = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            inputDirectives.foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$sampleDataLenses$1(this, nameIdentifier, uri, lenses, id)));
            object = BoxedUnit.UNIT;
        } else {
            SampleInput[] scenarioInputs = ((Scenario)maybeScenario.get()).inputs();
            Map inputs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name());
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scenarioInputs)).isEmpty() && inputDirectives.isEmpty()) {
                Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_SCENARIO(), Arrays.asList(nameIdentifier.name(), uri, ((Scenario)maybeScenario.get()).name()));
                object = BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(this.docStartRange(), command, null)));
            } else {
                inputDirectives.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    if (!inputs.contains((Object)id.variable().name())) {
                        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE(), Arrays.asList(nameIdentifier.name(), ((Scenario)maybeScenario.get()).name(), uri, id.variable().name(), this.inputFileName((InputDirective)id)));
                        return BoxesRunTime.boxToBoolean((boolean)lenses.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null)));
                    }
                    return BoxedUnit.UNIT;
                });
                object = BoxedUnit.UNIT;
            }
        }
        return lenses;
    }

    private Range docStartRange() {
        Position docStart = new Position(0, 0);
        return new Range(docStart, docStart);
    }

    private CodeLens runMappingLens(NameIdentifier nameIdentifier) {
        Command runMappingCommand = new Command("Run Mapping", Commands$.MODULE$.DW_LAUNCH_MAPPING(), Arrays.asList(URLUtils$.MODULE$.toLSPUrl(Path.of(this.projectKind.project().getLocation()).toFile()), nameIdentifier.name(), LaunchConfiguration$.MODULE$.DATA_WEAVE_CONFIG_TYPE_NAME(), "false"));
        return new CodeLens(this.docStartRange(), runMappingCommand, null);
    }

    private String inputFileName(InputDirective id) {
        String extension = (String)id.mime().map((Function1 & Serializable & scala.Serializable)mime -> {
            String string = mime.mime();
            if ("application/json".equals(string)) {
                return ".json";
            }
            if ("application/java".equals(string)) {
                return ".dwl";
            }
            if ("application/xml".equals(string)) {
                return ".xml";
            }
            if ("application/yaml".equals(string)) {
                return ".yaml";
            }
            if ("application/x-ndjson".equals(string)) {
                return ".ndjson";
            }
            if ("application/octet-stream".equals(string)) {
                return ".bin";
            }
            if ("application/x-java-properties".equals(string)) {
                return ".properties";
            }
            if ("multipart/form-data".equals(string)) {
                return ".multipart";
            }
            if ("multipart/x-www-form-urlencoded".equals(string)) {
                return ".urlencoded";
            }
            if ("application/csv".equals(string) ? true : "text/csv".equals(string)) {
                return ".csv";
            }
            if ("text/plain".equals(string)) {
                return ".txt";
            }
            return new StringBuilder(1).append(".").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split("/"))).last()).toString();
        }).orElse((Function0 & Serializable & scala.Serializable)() -> id.dataFormat().map((Function1 & Serializable & scala.Serializable)id -> {
            String string = id.id();
            if ("text".equals(string)) {
                return ".txt";
            }
            if ("java".equals(string)) {
                return ".dwl";
            }
            if ("excel".equals(string)) {
                return ".xlsx";
            }
            if ("binary".equals(string)) {
                return ".bin";
            }
            return new StringBuilder(1).append(".").append(string).toString();
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".json");
        return new StringBuilder(0).append(id.variable().name()).append(extension).toString();
    }

    private ArrayList<CodeLens> addDocumentationLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result = new ArrayList<CodeLens>();
        Seq functionNodes = AstNodeHelper$.MODULE$.collectChildrenWith(ast, FunctionDirectiveNode.class);
        ((IterableLike)functionNodes.filter((Function1 & Serializable & scala.Serializable)fd -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addDocumentationLenses$1(fd)))).foreach((Function1 & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addDocumentationLenses$2(uri, result, astNode)));
        return result;
    }

    private ArrayList<CodeLens> addUnitTestLenses(AstNode ast, String uri) {
        ArrayList<CodeLens> result;
        block1: {
            result = new ArrayList<CodeLens>();
            if (!ProjectStructureHelper$.MODULE$.defaultTestSourceFolder(this.projectKind.structure()).isDefined()) break block1;
            AstNode astNode2 = ast;
            if (astNode2 instanceof ModuleNode) {
                ModuleNode moduleNode = (ModuleNode)astNode2;
                Seq topLevelFunctions = AstNodeHelper$.MODULE$.collectDirectChildrenWith((AstNode)moduleNode, FunctionDirectiveNode.class);
                topLevelFunctions.foreach((Function1 & Serializable & scala.Serializable)astNode -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$addUnitTestLenses$1(uri, result, astNode)));
            }
        }
        return result;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<java.util.List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService service = this.toolingServices().openDocument(params.getTextDocument().getUri());
            FoldingRange[] regions = (FoldingRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])service.foldingRegions())).map((Function1 & Serializable & scala.Serializable)fr -> {
                FoldingRange range = new FoldingRange(fr.location().startPosition().line() - 1, fr.location().endPosition().line() - 1);
                int n = fr.kind();
                String kind = RegionKind$.MODULE$.COMMENTS() == n ? "comment" : "region";
                range.setKind(kind);
                return range;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FoldingRange.class)));
            return Arrays.asList((Object[])regions);
        });
    }

    public CompletableFuture<java.util.List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        String uri = params.getTextDocument().getUri();
        org.mule.weave.v2.editor.VirtualFile vf = this.vfs().file(uri);
        if (vf == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, new StringBuilder(110).append("Invalid request codeAction(").append(params.getTextDocument().getUri()).append("), virtual file not registered as opened yet didOpen should have been called first.").toString(), null);
            return CompletableFuture.failedFuture((Throwable)new ResponseErrorException(error));
        }
        Optional contextMetadata = this.projectKind.metadataProvider().metadata((VirtualFile)VirtualFileAdapter$.MODULE$.apply(vf));
        return CompletableFuture.supplyAsync(() -> {
            Seq<CodeAction> actions = this.codeActionsManagerService().codeActionsFor(params, contextMetadata);
            ArrayList result = new ArrayList();
            actions.foreach((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)result.add(Either.forRight((Object)a))));
            return result;
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            Position position = params.getPosition();
            int offset = toolingService.offsetOf(position.getLine(), position.getCharacter());
            return (Hover)toolingService.hoverResult(offset).map((Function1 & Serializable & scala.Serializable)hm -> {
                Hover hoverResult = new Hover();
                boolean x$1 = false;
                boolean x$2 = true;
                boolean x$3 = false;
                Seq x$4 = (Seq)new .colon.colon((Object)"Documentation", (List)Nil$.MODULE$);
                boolean x$5 = true;
                boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                boolean x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                Option x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$1, x$2, x$6, x$7, x$8, x$3, x$9, x$5, x$10, x$11, x$12, x$13, x$4, x$14, x$15, x$16);
                String expressionType = (String)Option$.MODULE$.apply((Object)hm.resultType()).map((Function1 & Serializable & scala.Serializable)wt -> new StringBuilder(9).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`\n").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                String documentation = new StringBuilder(1).append(expressionType).append("\n").append(hm.markdownDocs().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                hoverResult.setContents(new MarkupContent("markdown", documentation));
                hoverResult.setRange(LSPConverters$.MODULE$.toRange(hm.weaveLocation()));
                return hoverResult;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)toolingService.typeOf(offset)).map((Function1 & Serializable & scala.Serializable)wt -> {
                Hover hoverResult;
                block0: {
                    hoverResult = new Hover();
                    boolean x$17 = false;
                    boolean x$18 = true;
                    boolean x$19 = false;
                    boolean x$20 = true;
                    boolean x$21 = WeaveTypeEmitterConfig$.MODULE$.apply$default$3();
                    boolean x$22 = WeaveTypeEmitterConfig$.MODULE$.apply$default$4();
                    boolean x$23 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
                    boolean x$24 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
                    boolean x$25 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
                    boolean x$26 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
                    boolean x$27 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
                    boolean x$28 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
                    Seq x$29 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
                    boolean x$30 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
                    boolean x$31 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
                    Option x$32 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
                    WeaveTypeEmitterConfig typeEmitterConfig = new WeaveTypeEmitterConfig(x$17, x$18, x$21, x$22, x$23, x$19, x$24, x$20, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32);
                    String expressionType = new StringBuilder(8).append("Type: `").append(wt.toString(typeEmitterConfig)).append("`").toString();
                    hoverResult.setContents(new MarkupContent("markdown", expressionType));
                    if (wt.location().startPosition().index() < 0) break block0;
                    hoverResult.setRange(LSPConverters$.MODULE$.toRange(wt.location()));
                }
                return hoverResult;
            })).orNull(Predef$.MODULE$.$conforms());
        }, this.executor);
    }

    public SymbolKind toSymbolKind(int kind) {
        int n = kind;
        if (SymbolKind$.MODULE$.Array() == n) {
            return SymbolKind.Array;
        }
        if (SymbolKind$.MODULE$.Boolean() == n) {
            return SymbolKind.Boolean;
        }
        if (SymbolKind$.MODULE$.Class() == n) {
            return SymbolKind.Class;
        }
        if (SymbolKind$.MODULE$.Constant() == n) {
            return SymbolKind.Constant;
        }
        if (SymbolKind$.MODULE$.Field() == n) {
            return SymbolKind.Field;
        }
        if (SymbolKind$.MODULE$.Module() == n) {
            return SymbolKind.Module;
        }
        if (SymbolKind$.MODULE$.Property() == n) {
            return SymbolKind.Property;
        }
        if (SymbolKind$.MODULE$.Namespace() == n) {
            return SymbolKind.Namespace;
        }
        if (SymbolKind$.MODULE$.String() == n) {
            return SymbolKind.String;
        }
        if (SymbolKind$.MODULE$.Variable() == n) {
            return SymbolKind.Variable;
        }
        if (SymbolKind$.MODULE$.Constructor() == n) {
            return SymbolKind.Constructor;
        }
        if (SymbolKind$.MODULE$.Enum() == n) {
            return SymbolKind.Enum;
        }
        if (SymbolKind$.MODULE$.Method() == n) {
            return SymbolKind.Method;
        }
        if (SymbolKind$.MODULE$.Function() == n) {
            return SymbolKind.Function;
        }
        if (SymbolKind$.MODULE$.File() == n) {
            return SymbolKind.File;
        }
        if (SymbolKind$.MODULE$.Package() == n) {
            return SymbolKind.Package;
        }
        if (SymbolKind$.MODULE$.Interface() == n) {
            return SymbolKind.Interface;
        }
        return SymbolKind.Property;
    }

    public CompletableFuture<java.util.List<Either<org.eclipse.lsp4j.SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> {
            TextDocumentIdentifier document = params.getTextDocument();
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(document.getUri());
            ArrayList result = new ArrayList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toolingService.documentSymbol())).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$documentSymbol$2(this, result, e)));
            return result;
        }, this.executor);
    }

    public CompletableFuture<Either<java.util.List<? extends Location>, java.util.List<? extends LocationLink>>> definition(DefinitionParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            ArrayList result = new ArrayList();
            Link[] definitions = toolingService.definitions(offset);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definitions)).foreach((Function1 & Serializable & scala.Serializable)ll -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$definition$2(this, params, result, ll)));
            return Either.forRight(result);
        }, this.executor);
    }

    private Option<String> resolveUrl(NameIdentifier moduleName) {
        WeaveResourceResolver resourceResolver = this.vfs().asResourceResolver();
        Option maybeUrl = resourceResolver.resolve(moduleName).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.url());
        return maybeUrl;
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            toolingService.formatDocument((WeaveTextDocument)textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<java.util.List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            LSPWeaveTextDocument textDocument = new LSPWeaveTextDocument(toolingService);
            Range range = params.getRange();
            int startOffset = toolingService.offsetOf(range.getStart().getLine(), range.getStart().getCharacter());
            int endOffset = toolingService.offsetOf(range.getEnd().getLine(), range.getEnd().getCharacter());
            toolingService.format(startOffset, endOffset, (WeaveTextDocument)textDocument, new FormattingOptions(params.getOptions().getTabSize(), params.getOptions().isInsertSpaces()));
            return textDocument.edits();
        }, this.executor);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] ref2 = toolingService.rename(offset, params.getNewName());
            WorkspaceEdit edit = new WorkspaceEdit();
            NameIdentifier localNameIdentifier = toolingService.file().getNameIdentifier();
            Map renamesByDocument = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ref2)).groupBy((Function1 & Serializable & scala.Serializable)ref -> (NameIdentifier)ref.moduleSource().getOrElse((Function0 & Serializable & scala.Serializable)() -> localNameIdentifier));
            renamesByDocument.foreach((Function1 & Serializable & scala.Serializable)references -> {
                Option<String> option = this.resolveUrl((NameIdentifier)references._1());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String url = (String)some.value();
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])references._2())).map((Function1 & Serializable & scala.Serializable)reference -> {
                        Location location = this.textDocumentTranslator().translate(url, LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
                        ArrayList<TextEdit> changes = (ArrayList<TextEdit>)edit.getChanges().get(location.getUri());
                        if (changes == null) {
                            changes = new ArrayList<TextEdit>();
                        }
                        changes.add(new TextEdit(location.getRange(), params.getNewName()));
                        return edit.getChanges().put(location.getUri(), changes);
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.util.List.class)));
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(option);
            });
            return edit;
        }, this.executor);
    }

    public CompletableFuture<java.util.List<? extends Location>> references(ReferenceParams params) {
        return CompletableFuture.supplyAsync(() -> {
            WeaveDocumentToolingService toolingService = this.toolingServices().openDocument(params.getTextDocument().getUri());
            int offset = toolingService.offsetOf(params.getPosition().getLine(), params.getPosition().getCharacter());
            Reference[] referencesResult = toolingService.references(offset);
            return JavaConverters$.MODULE$.seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])referencesResult)).map((Function1 & Serializable & scala.Serializable)r -> {
                String url = r.isLocalReference() ? params.getTextDocument().getUri() : (String)this.resolveUrl((NameIdentifier)r.moduleSource().get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                Range range = LSPConverters$.MODULE$.toRange(r.referencedNode().location());
                return this.textDocumentTranslator().translate(url, range);
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
        }, this.executor);
    }

    private CompletionItemKind getCompletionType(Suggestion sug) {
        int n = sug.itemType();
        if (SuggestionType$.MODULE$.Class() == n) {
            return CompletionItemKind.Class;
        }
        if (SuggestionType$.MODULE$.Constructor() == n) {
            return CompletionItemKind.Constructor;
        }
        if (SuggestionType$.MODULE$.Field() == n) {
            return CompletionItemKind.Field;
        }
        if (SuggestionType$.MODULE$.Enum() == n) {
            return CompletionItemKind.Enum;
        }
        if (SuggestionType$.MODULE$.Function() == n) {
            return CompletionItemKind.Function;
        }
        if (SuggestionType$.MODULE$.Keyword() == n) {
            return CompletionItemKind.Keyword;
        }
        if (SuggestionType$.MODULE$.Module() == n) {
            return CompletionItemKind.Module;
        }
        if (SuggestionType$.MODULE$.Method() == n) {
            return CompletionItemKind.Method;
        }
        if (SuggestionType$.MODULE$.Property() == n) {
            return CompletionItemKind.Property;
        }
        if (SuggestionType$.MODULE$.Variable() == n) {
            return CompletionItemKind.Variable;
        }
        return CompletionItemKind.Property;
    }

    public static final /* synthetic */ void $anonfun$semanticTokensFull$2(IntRef encodedModifiers$1, String attr) {
        int value = DWSemanticTokensLegend$.MODULE$.legend().getTokenModifiers().indexOf(attr);
        if (value != -1) {
            encodedModifiers$1.elem |= 1 << value;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getSuggestionsAndCreateCompletionList$1(DataWeaveDocumentService $this, IntRef i$1, SuggestionResult suggestionResult$1, WeaveDocumentToolingService toolingService$1, ArrayList result$1, Suggestion sug) {
        String index = Integer.toString(i$1.elem);
        String prefix = new StringOps(Predef$.MODULE$.augmentString("0")).$times(suggestionResult$1.suggestions().length - index.length());
        CompletionItem item = new CompletionItem(sug.name());
        item.setDetail((String)sug.wtype().map((Function1 & Serializable & scala.Serializable)wt -> {
            boolean x$1 = false;
            boolean x$2 = true;
            boolean x$3 = true;
            boolean x$4 = false;
            boolean x$5 = false;
            boolean x$6 = WeaveTypeEmitterConfig$.MODULE$.apply$default$5();
            boolean x$7 = WeaveTypeEmitterConfig$.MODULE$.apply$default$7();
            boolean x$8 = WeaveTypeEmitterConfig$.MODULE$.apply$default$8();
            boolean x$9 = WeaveTypeEmitterConfig$.MODULE$.apply$default$9();
            boolean x$10 = WeaveTypeEmitterConfig$.MODULE$.apply$default$10();
            boolean x$11 = WeaveTypeEmitterConfig$.MODULE$.apply$default$11();
            boolean x$12 = WeaveTypeEmitterConfig$.MODULE$.apply$default$12();
            Seq x$13 = WeaveTypeEmitterConfig$.MODULE$.apply$default$13();
            boolean x$14 = WeaveTypeEmitterConfig$.MODULE$.apply$default$14();
            boolean x$15 = WeaveTypeEmitterConfig$.MODULE$.apply$default$15();
            Option x$16 = WeaveTypeEmitterConfig$.MODULE$.apply$default$16();
            WeaveTypeEmitterConfig emitterConfig = new WeaveTypeEmitterConfig(x$1, x$3, x$4, x$2, x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            return wt.toString(emitterConfig);
        }).orNull(Predef$.MODULE$.$conforms()));
        item.setSortText(new StringBuilder(0).append(prefix).append(index).toString());
        item.setDocumentation(new MarkupContent("markdown", (String)sug.markdownDocumentation().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
        int startIndex = suggestionResult$1.replacementStart();
        int endIndex = suggestionResult$1.replacementEnd();
        org.mule.weave.v2.parser.location.Position startPosition = toolingService$1.file().asResource().positionOf(startIndex);
        org.mule.weave.v2.parser.location.Position endPosition = toolingService$1.file().asResource().positionOf(endIndex);
        TextEdit edit = new TextEdit(new Range(LSPConverters$.MODULE$.toPosition(startPosition), LSPConverters$.MODULE$.toPosition(endPosition)), sug.template().toVSCodeString());
        item.setTextEdit(Either.forLeft((Object)edit));
        item.setFilterText(sug.template().toVSCodeString());
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setKind($this.getCompletionType(sug));
        result$1.add(item);
        ++i$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getInputDirectives$3(InputDirective inputDirective) {
        return !NameIdentifier$.MODULE$.INSERTED_FAKE_VARIABLE().equals((Object)inputDirective.variable()) && AstNodeHelper$.MODULE$.notInjectedNode((AstNode)inputDirective);
    }

    public static final /* synthetic */ AstNode $anonfun$codeLens$2(AstNodeResult x$1) {
        return x$1.astNode();
    }

    public static final /* synthetic */ Object $anonfun$codeLens$3(DataWeaveDocumentService $this, ArrayList result$2, String uri$1, AstNode ast) {
        result$2.addAll($this.addDocumentationLenses(ast, uri$1));
        if ($this.supportAddUnitTestCodeLens) {
            return BoxesRunTime.boxToBoolean((boolean)result$2.addAll($this.addUnitTestLenses(ast, uri$1)));
        }
        return BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ java.util.List $anonfun$codeLens$1(DataWeaveDocumentService $this, CodeLensParams params$2) {
        block5: {
            block7: {
                block6: {
                    uri = params$2.getTextDocument().getUri();
                    result = new ArrayList<CodeLens>();
                    documentToolingService = $this.toolingServices().openDocument(params$2.getTextDocument().getUri());
                    nameIdentifier = documentToolingService.file().getNameIdentifier();
                    maybeAstNode = documentToolingService.ast().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$2(org.mule.weave.v2.editor.AstNodeResult ), (Lorg/mule/weave/v2/editor/AstNodeResult;)Lorg/mule/weave/v2/parser/ast/AstNode;)());
                    maybeString = WeaveASTQueryUtils$.MODULE$.fileKind((Option<AstNode>)maybeAstNode);
                    if (documentToolingService.file().readOnly()) break block5;
                    var9_8 = false;
                    var10_9 = null;
                    var11_10 = maybeString;
                    if (!(var11_10 instanceof Some)) break block6;
                    var9_8 = true;
                    var10_9 = (Some)var11_10;
                    var12_11 = (String)var10_9.value();
                    v0 = WeaveASTQueryUtils$.MODULE$.MODULE();
                    var13_12 = var12_11;
                    if (v0 != null ? v0.equals(var13_12) == false : var13_12 != null) break block6;
                    BoxesRunTime.boxToBoolean((boolean)result.addAll($this.createMappingTestLens(documentToolingService.file().url())));
                    break block7;
                }
                if (!var9_8) ** GOTO lbl-1000
                var14_13 = (String)var10_9.value();
                v1 = WeaveASTQueryUtils$.MODULE$.MAPPING();
                var15_14 = var14_13;
                if (!(v1 != null ? v1.equals(var15_14) == false : var15_14 != null)) {
                    maybeScenario = $this.scenariosService().activeScenario(nameIdentifier);
                    inputDirectives = $this.getInputDirectives((Option<AstNode>)maybeAstNode);
                    result.addAll($this.sampleDataLenses(maybeScenario, nameIdentifier, inputDirectives, uri));
                    if ($this.supportRunMappingLens) {
                        BoxesRunTime.boxToBoolean((boolean)result.add($this.runMappingLens(nameIdentifier)));
                    }
                } else if (var9_8) {
                    var18_17 = (String)var10_9.value();
                    v2 = WeaveASTQueryUtils$.MODULE$.BAT();
                    var19_18 = var18_17;
                    if (!(v2 != null ? v2.equals(var19_18) == false : var19_18 != null)) {
                        command = new Command("Run BAT Test", Commands$.MODULE$.DW_LAUNCH_MAPPING(), Arrays.asList(new Object[]{URLUtils$.MODULE$.toLSPUrl(Path.of($this.projectKind.project().getLocation()).toFile()), nameIdentifier.name(), LaunchConfiguration$.MODULE$.BAT_CONFIG_TYPE_NAME(), "false"}));
                        BoxesRunTime.boxToBoolean((boolean)result.add(new CodeLens($this.docStartRange(), command, null)));
                    }
                }
            }
            maybeAstNode.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$codeLens$3(org.mule.weave.lsp.services.DataWeaveDocumentService java.util.ArrayList java.lang.String org.mule.weave.v2.parser.ast.AstNode ), (Lorg/mule/weave/v2/parser/ast/AstNode;)Ljava/lang/Object;)((DataWeaveDocumentService)$this, result, (String)uri));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$sampleDataLenses$1(DataWeaveDocumentService $this, NameIdentifier nameIdentifier$1, String uri$2, ArrayList lenses$1, InputDirective id) {
        Command command = new Command(UserMessages$.MODULE$.defineSampleData(), Commands$.MODULE$.DW_CREATE_INPUT_SAMPLE(), Arrays.asList(nameIdentifier$1.name(), Scenario$.MODULE$.PLAYGROUND_SCENARIO(), uri$2, id.variable().name(), $this.inputFileName(id)));
        return lenses$1.add(new CodeLens(LSPConverters$.MODULE$.toRange(id.location()), command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$1(FunctionDirectiveNode fd) {
        return fd.weaveDoc().isEmpty() && !(fd.literal() instanceof OverloadedFunctionNode);
    }

    public static final /* synthetic */ boolean $anonfun$addDocumentationLenses$2(String uri$3, ArrayList result$3, FunctionDirectiveNode astNode) {
        Command command = InsertDocumentationCommand$.MODULE$.createCommand(uri$3, (AstNode)astNode);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$3.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$addUnitTestLenses$1(String uri$4, ArrayList result$4, FunctionDirectiveNode astNode) {
        Command command = CreateUnitTest$.MODULE$.createCommand(uri$4, (AstNode)astNode);
        Range range = new Range(LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()), LSPConverters$.MODULE$.toPosition(astNode.location().startPosition()));
        return result$4.add(new CodeLens(range, command, null));
    }

    public static final /* synthetic */ boolean $anonfun$documentSymbol$2(DataWeaveDocumentService $this, ArrayList result$6, SymbolInformation e) {
        DocumentSymbol symbol = new DocumentSymbol();
        symbol.setName(e.name());
        symbol.setSelectionRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setRange(LSPConverters$.MODULE$.toRange(e.location()));
        symbol.setKind($this.toSymbolKind(e.kind()));
        return result$6.add(Either.forRight((Object)symbol));
    }

    public static final /* synthetic */ boolean $anonfun$definition$4(Link ll$1, SampleInput sampleInput) {
        return sampleInput.name().equals(ll$1.linkLocation().name());
    }

    public static final /* synthetic */ void $anonfun$definition$5(LocationLink link$1, SampleInput sampleInput) {
        Position position = new Position(0, 0);
        link$1.setTargetRange(new Range(position, position));
        link$1.setTargetSelectionRange(new Range(position, position));
        link$1.setTargetUri(sampleInput.uri());
    }

    public static final /* synthetic */ void $anonfun$definition$3(Link ll$1, LocationLink link$1, Scenario activeScenario) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeScenario.inputs())).find((Function1 & Serializable & scala.Serializable)sampleInput -> BoxesRunTime.boxToBoolean((boolean)DataWeaveDocumentService.$anonfun$definition$4(ll$1, sampleInput))).foreach((Function1 & Serializable & scala.Serializable)sampleInput -> {
            DataWeaveDocumentService.$anonfun$definition$5(link$1, sampleInput);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$definition$2(DataWeaveDocumentService $this, DefinitionParams params$7, ArrayList result$7, Link ll) {
        LocationLink link = new LocationLink();
        link.setOriginSelectionRange(LSPConverters$.MODULE$.toRange(ll.linkLocation().location()));
        Reference reference = ll.reference();
        link.setTargetRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        link.setTargetSelectionRange(LSPConverters$.MODULE$.toRange(reference.referencedNode().location()));
        if (reference.isLocalReference()) {
            link.setTargetUri(params$7.getTextDocument().getUri());
            $this.scenariosService().activeScenario($this.vfs().file(params$7.getTextDocument().getUri()).getNameIdentifier()).foreach((Function1 & Serializable & scala.Serializable)activeScenario -> {
                DataWeaveDocumentService.$anonfun$definition$3(ll, link, activeScenario);
                return BoxedUnit.UNIT;
            });
        } else {
            NameIdentifier moduleName = (NameIdentifier)reference.moduleSource().get();
            Option<String> maybeUrl = $this.resolveUrl(moduleName);
            Option<String> option = maybeUrl;
            if (option instanceof Some) {
                Some some = (Some)option;
                String url = (String)some.value();
                link.setTargetUri(url);
            } else if (None$.MODULE$.equals(option)) {
                $this.logger().warn(new StringBuilder(23).append("Resource not found for ").append(moduleName).toString());
            } else {
                throw new MatchError(option);
            }
        }
        return result$7.add(link);
    }

    public DataWeaveDocumentService(ProjectKind projectKind, Executor executor, boolean supportAddUnitTestCodeLens, boolean supportRunMappingLens) {
        this.projectKind = projectKind;
        this.executor = executor;
        this.supportAddUnitTestCodeLens = supportAddUnitTestCodeLens;
        this.supportRunMappingLens = supportRunMappingLens;
        this.logger = LoggerFactory.getLogger(DataWeaveDocumentService.class);
        this.toolingServices = projectKind.toolingService(DataWeaveToolingService.class);
        this.projectFS = projectKind.toolingService(ProjectFileSystemService.class);
        this.scenariosService = projectKind.toolingService(WeaveScenarioManagerService.class);
        this.vfs = projectKind.vfs();
        this.codeActionsManagerService = projectKind.toolingService(CodeActionsManagerService.class);
        this.textDocumentTranslator = projectKind.toolingService(TextDocumentTranslatorService.class);
    }
}

