package org.mule.weave.lsp.actions

import org.eclipse.lsp4j.CodeAction
import org.eclipse.lsp4j.CodeActionParams
import org.mule.weave.extension.api.extension.action.WeaveCodeActionProvider
import org.mule.weave.extension.api.metadata.ContextMetadata
import org.mule.weave.lsp.commands.InsertWeaveTypeCommand
import org.mule.weave.lsp.services.DataWeaveToolingService
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import java.util.Optional.ofNullable

class InsertWeaveTypeAction(toolingService: DataWeaveToolingService) extends WeaveCodeActionProvider {
  
  override def handles(params: CodeActionParams, context: ContextMetadata): Boolean = {
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, ofNullable(context))
    documentToolingService 
      .nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[FunctionDirectiveNode])).map(_.astNode)
      .orElse({
        documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[VarDirective])).map(_.astNode)
      })
      .orElse({
        documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[InputDirective])).map(_.astNode)
      })
      .collect({
        case functionDirectiveNode: FunctionDirectiveNode => functionDirectiveNode.literal
        case varDirective: VarDirective => varDirective
        case varDirective: InputDirective => varDirective
      })
      .exists(astNode => {
        astNode match {
          case fn: FunctionNode => fn.returnType.isEmpty
          case vd: VarDirective => vd.wtype.isEmpty
          case id: InputDirective => id.wtype.isEmpty
          case _ => false
        }
      })
  }

  override def actions(params: CodeActionParams, context: ContextMetadata): Array[CodeAction] = {
    val documentToolingService = toolingService.openDocument(params.getTextDocument.getUri, ofNullable(context))
    val maybeNode = documentToolingService.nodeAt(params.getRange.getStart.getLine, params.getRange.getStart.getCharacter, Some(classOf[NameIdentifier])).map(_.astNode)
    val codeAction = new CodeAction("Add Type Annotation")
    maybeNode match {
      case Some(astNode: NameIdentifier) =>
        codeAction.setCommand(InsertWeaveTypeCommand.createCommand(params.getTextDocument.getUri, astNode))
        Array(codeAction)
      case _ =>
        Array.empty
    }

  }
}
