/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.commands;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.weave.extension.api.extension.command.WeaveCommand;
import org.mule.weave.lsp.commands.Commands$;
import org.mule.weave.lsp.commands.CreateUnitTest$;
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams;
import org.mule.weave.lsp.extension.protocol.OpenTextDocumentParams$;
import org.mule.weave.lsp.i18n.UserMessages$;
import org.mule.weave.lsp.project.ProjectKind;
import org.mule.weave.lsp.project.components.ProjectStructureHelper$;
import org.mule.weave.lsp.services.DataWeaveToolingService;
import org.mule.weave.lsp.services.TextDocumentTranslatorService;
import org.mule.weave.lsp.services.UIService;
import org.mule.weave.lsp.services.WorkspaceEditService;
import org.mule.weave.lsp.services.WorkspaceServiceManager;
import org.mule.weave.lsp.utils.URLUtils$;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveUnitTestAddition;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.location.Position;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001\u0002\f\u0018\u0001\tB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)\u0011\t\u0001C\u0001\u0005\")q\t\u0001C!\u0011\")a\u000b\u0001C!/\")a\r\u0001C\u0005O\"9\u0011Q\u0005\u0001\u0005\n\u0005\u001dRABA\u001d\u0001\u0001\tY\u0004C\u0004\u0002X\u0001!I!!\u0017\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005\"CAN\u0001E\u0005I\u0011BAO\u0011\u001d\t\u0019\f\u0001C\u0005\u0003kCq!a1\u0001\t\u0013\t)\rC\u0004\u0002P\u0002!I!!5\t\r\u0005]\u0007\u0001\"\u0011I\u0011\u001d\tI\u000e\u0001C!\u00037<q!a8\u0018\u0011\u0003\t\tO\u0002\u0004\u0017/!\u0005\u00111\u001d\u0005\u0007\u0003N!\t!!:\t\u000f\u0005\u001d8\u0003\"\u0001\u0002j\nq1I]3bi\u0016,f.\u001b;UKN$(B\u0001\r\u001a\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\u000e\u001c\u0003\ra7\u000f\u001d\u0006\u00039u\tQa^3bm\u0016T!AH\u0010\u0002\t5,H.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aI\u0016\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001\u00027b]\u001eT\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t1qJ\u00196fGR\u0004\"\u0001\f\u001b\u000e\u00035R!AL\u0018\u0002\u000f\r|W.\\1oI*\u0011\u0001'M\u0001\nKb$XM\\:j_:T!AM\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u000217%\u0011Q'\f\u0002\r/\u0016\fg/Z\"p[6\fg\u000eZ\u0001\u0018o>\u00148n\u001d9bG\u0016\u001cVM\u001d<jG\u0016l\u0015M\\1hKJ\u0004\"\u0001O\u001e\u000e\u0003eR!AO\r\u0002\u0011M,'O^5dKNL!\u0001P\u001d\u0003/]{'o[:qC\u000e,7+\u001a:wS\u000e,W*\u00198bO\u0016\u0014\u0018!C;J'\u0016\u0014h/[2f!\tAt(\u0003\u0002As\tIQ+S*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r+e\t\u0005\u0002E\u00015\tq\u0003C\u00037\u0007\u0001\u0007q\u0007C\u0003>\u0007\u0001\u0007a(A\u0005d_6l\u0017M\u001c3JIR\t\u0011\n\u0005\u0002K':\u00111*\u0015\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0006\na\u0001\u0010:p_Rt$\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{\u0015A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!AU(\u0002\u000f\u0015DXmY;uKR\u0011\u0001\f\u0018\t\u00033jk\u0011aT\u0005\u00037>\u0013a!\u00118z%\u00164\u0007\"B/\u0006\u0001\u0004q\u0016A\u00029be\u0006l7\u000f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006)An\u001d95U*\u00111mH\u0001\bK\u000ed\u0017\u000e]:f\u0013\t)\u0007M\u0001\u000bFq\u0016\u001cW\u000f^3D_6l\u0017M\u001c3QCJ\fWn]\u0001\rI>\u001c%/Z1uKR+7\u000f\u001e\u000b\u000eQ.\u001cXO_A\u0005\u0003'\t9\"a\u0007\u0011\u0005eK\u0017B\u00016P\u0005\u0011)f.\u001b;\t\u000b14\u0001\u0019A7\u0002\u0011Q,7\u000f\u001e$jY\u0016\u0004\"A\\9\u000e\u0003=T!\u0001]\u0014\u0002\u0005%|\u0017B\u0001:p\u0005\u00111\u0015\u000e\\3\t\u000bQ4\u0001\u0019A%\u0002\u0017Q,7\u000f\u001e$jY\u0016,&\u000b\u0014\u0005\u0006m\u001a\u0001\ra^\u0001\u0018I\u0006$\u0018mV3bm\u0016$vn\u001c7j]\u001e\u001cVM\u001d<jG\u0016\u0004\"\u0001\u000f=\n\u0005eL$a\u0006#bi\u0006<V-\u0019<f)>|G.\u001b8h'\u0016\u0014h/[2f\u0011\u0015Yh\u00011\u0001}\u0003Y!wnY;nK:$Hk\\8mS:<7+\u001a:wS\u000e,\u0007cA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\ta!\u001a3ji>\u0014(bAA\u00027\u0005\u0011aOM\u0005\u0004\u0003\u000fq(aG,fCZ,Gi\\2v[\u0016tG\u000fV8pY&twmU3sm&\u001cW\rC\u0004\u0002\f\u0019\u0001\r!!\u0004\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u00043\u0006=\u0011bAA\t\u001f\n\u0019\u0011J\u001c;\t\u000f\u0005Ua\u00011\u0001\u0002\u000e\u0005IQM\u001c3PM\u001a\u001cX\r\u001e\u0005\u0007\u000331\u0001\u0019\u0001 \u0002'],\u0017M^3MC:<W/Y4f\u00072LWM\u001c;\t\u000f\u0005ua\u00011\u0001\u0002 \u0005!ro\u001c:lgB\f7-Z#eSR\u001cVM\u001d<jG\u0016\u00042\u0001OA\u0011\u0013\r\t\u0019#\u000f\u0002\u0015/>\u00148n\u001d9bG\u0016,E-\u001b;TKJ4\u0018nY3\u0002%\u0005$G\rV3tiR{'\t\\1oW\u001aKG.\u001a\u000b\u0010Q\u0006%\u00121FA\u0017\u0003_\t\t$a\r\u00026!)An\u0002a\u0001[\")Ao\u0002a\u0001\u0013\")1p\u0002a\u0001y\"9\u00111B\u0004A\u0002\u00055\u0001bBA\u000b\u000f\u0001\u0007\u0011Q\u0002\u0005\u0007\u000339\u0001\u0019\u0001 \t\u000f\u0005]r\u00011\u0001\u0002 \u0005qA.\u00198hk\u0006<Wm\u00117jK:$(\u0001B#eSR\u0004\u0002\"!\u0010\u0002H\u0005-\u0013\u0011K\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005AQ.Z:tC\u001e,7OC\u0002\u0002F\u0001\fqA[:p]J\u00048-\u0003\u0003\u0002J\u0005}\"AB#ji\",'\u000fE\u0002`\u0003\u001bJ1!a\u0014a\u0005A!V\r\u001f;E_\u000e,X.\u001a8u\u000b\u0012LG\u000fE\u0002`\u0003'J1!!\u0016a\u0005E\u0011Vm]8ve\u000e,w\n]3sCRLwN\\\u0001\u001aC\u0012$G+Z:u)>,\u00050[:uS:<G+Z:u\u0007>$W\rF\ti\u00037\ni&a\u0018\u0002b\u0005\r\u0014QMA4\u0003SBQ\u0001\\\u0005A\u00025DQ\u0001^\u0005A\u0002%CQA^\u0005A\u0002]DQa_\u0005A\u0002qDq!a\u0003\n\u0001\u0004\ti\u0001C\u0004\u0002\u0016%\u0001\r!!\u0004\t\u000buJ\u0001\u0019\u0001 \t\u000f\u0005u\u0011\u00021\u0001\u0002 \u0005yq-\u001a;UKN$\u0018\t\u001a3ji&|g\u000e\u0006\u0006\u0002p\u0005m\u0014qPAA\u0003\u0007\u0003R!WA9\u0003kJ1!a\u001dP\u0005\u0019y\u0005\u000f^5p]B\u0019Q0a\u001e\n\u0007\u0005edPA\u000bXK\u00064X-\u00168jiR+7\u000f^!eI&$\u0018n\u001c8\t\r\u0005u$\u00021\u0001}\u0003I!Xm\u001d;U_>d\u0017N\\4TKJ4\u0018nY3\t\u000bmT\u0001\u0019\u0001?\t\u000f\u0005-!\u00021\u0001\u0002\u000e!9\u0011Q\u0003\u0006A\u0002\u00055\u0011AD5og\u0016\u0014H\u000fV3yi\u0016#\u0017\u000e\u001e\u000b\u000b\u0003\u0013\u000bi)a$\u0002\u0014\u0006]\u0005cAAF\u00115\t\u0001\u0001C\u0003u\u0017\u0001\u0007\u0011\n\u0003\u0004\u0002\u0012.\u0001\r!S\u0001\u0005i\u0016\u001cH\u000fC\u0004\u0002\u0016.\u0001\r!!\u0004\u0002\t1Lg.\u001a\u0005\n\u00033[\u0001\u0013!a\u0001\u0003\u001b\taaY8mk6t\u0017\u0001G5og\u0016\u0014H\u000fV3yi\u0016#\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0014\u0016\u0005\u0003\u001b\t\tk\u000b\u0002\u0002$B!\u0011QUAX\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016!C;oG\",7m[3e\u0015\r\tikT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAY\u0003O\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003)\t\u0007\u000f\u001d7z\u000b\u0012LGo\u001d\u000b\u0006Q\u0006]\u0016\u0011\u0018\u0005\b\u0003;i\u0001\u0019AA\u0010\u0011\u001d\tY,\u0004a\u0001\u0003{\u000bQ!\u001a3jiN\u0004R!WA`\u0003wI1!!1P\u0005)a$/\u001a9fCR,GMP\u0001\fSN\u0014E.\u00198l\r&dW\r\u0006\u0003\u0002H\u00065\u0007cA-\u0002J&\u0019\u00111Z(\u0003\u000f\t{w\u000e\\3b]\")AN\u0004a\u0001[\u0006yQO\\1cY\u0016$vNU;o)\u0016\u001cH\u000fF\u0003i\u0003'\f)\u000eC\u0003m\u001f\u0001\u0007Q\u000eC\u0003>\u001f\u0001\u0007a(\u0001\u0003oC6,\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:$2!SAo\u0011\u0015i\u0016\u00031\u0001_\u00039\u0019%/Z1uKVs\u0017\u000e\u001e+fgR\u0004\"\u0001R\n\u0014\u0005MAFCAAq\u00035\u0019'/Z1uK\u000e{W.\\1oIR1\u00111^Ay\u0003k\u00042aXAw\u0013\r\ty\u000f\u0019\u0002\b\u0007>lW.\u00198e\u0011\u0019\t\u00190\u0006a\u0001\u0013\u0006\u0019QO]5\t\u000f\u0005]X\u00031\u0001\u0002z\u00069\u0011m\u001d;O_\u0012,\u0007\u0003BA~\u0005\u000bi!!!@\u000b\t\u0005}(\u0011A\u0001\u0004CN$(\u0002\u0002B\u0002\u0003\u0003\ta\u0001]1sg\u0016\u0014\u0018\u0002\u0002B\u0004\u0003{\u0014q!Q:u\u001d>$W\r")
public class CreateUnitTest
implements WeaveCommand {
    private final WorkspaceServiceManager workspaceServiceManager;
    private final UIService uIService;

    public static Command createCommand(String string, AstNode astNode) {
        return CreateUnitTest$.MODULE$.createCommand(string, astNode);
    }

    public String commandId() {
        return Commands$.MODULE$.DW_CREATE_UNIT_TEST();
    }

    public Object execute(ExecuteCommandParams params) {
        java.util.List args = params.getArguments();
        String uri = Commands$.MODULE$.argAsString(args, 0);
        Option<ProjectKind> maybeProjectKind = this.workspaceServiceManager.projectKind(uri);
        if (maybeProjectKind.isDefined()) {
            ProjectKind projectKind = (ProjectKind)maybeProjectKind.get();
            int startOffset = Commands$.MODULE$.argAsInt(args, 1);
            int endOffset = Commands$.MODULE$.argAsInt(args, 2);
            DataWeaveToolingService dataWeaveToolingService = projectKind.toolingService(DataWeaveToolingService.class);
            WeaveDocumentToolingService documentToolingService = dataWeaveToolingService.openDocument(uri);
            String testPath = documentToolingService.getTestPathFromDefinition();
            File weaveTestFolder = ProjectStructureHelper$.MODULE$.getOrCreateTestSourceFolder(projectKind.structure(), uri, projectKind.toolingService(TextDocumentTranslatorService.class));
            File testFile = new File(weaveTestFolder, testPath);
            String testFileURL = URLUtils$.MODULE$.toLSPUrl(testFile);
            this.doCreateTest(testFile, testFileURL, dataWeaveToolingService, documentToolingService, startOffset, endOffset, this.uIService, this.workspaceServiceManager.workspaceEditService());
        } else {
            this.uIService.showMessage(new MessageParams(MessageType.Error, new StringBuilder(50).append("No project is associated to: ").append(uri).append(". ").append(this.commandId()).append(" cannot be executed").toString()));
        }
        return null;
    }

    private void doCreateTest(File testFile, String testFileURL, DataWeaveToolingService dataWeaveToolingService, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset, UIService weaveLanguageClient, WorkspaceEditService workspaceEditService) {
        if (this.isBlankFile(testFile)) {
            this.addTestToBlankFile(testFile, testFileURL, documentToolingService, startOffset, endOffset, weaveLanguageClient, workspaceEditService);
            return;
        }
        this.addTestToExistingTestCode(testFile, testFileURL, dataWeaveToolingService, documentToolingService, startOffset, endOffset, weaveLanguageClient, workspaceEditService);
    }

    private void addTestToBlankFile(File testFile, String testFileURL, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset, UIService weaveLanguageClient, WorkspaceEditService languageClient) {
        Option maybeTest = documentToolingService.createUnitTestFromDefinition(startOffset, endOffset);
        maybeTest.foreach((Function1 & Serializable & scala.Serializable)test -> {
            CreateUnitTest.$anonfun$addTestToBlankFile$1(this, testFileURL, testFile, languageClient, weaveLanguageClient, test);
            return BoxedUnit.UNIT;
        });
    }

    private void addTestToExistingTestCode(File testFile, String testFileURL, DataWeaveToolingService dataWeaveToolingService, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset, UIService uIService, WorkspaceEditService workspaceEditService) {
        BoxedUnit boxedUnit;
        WeaveDocumentToolingService testToolingService = dataWeaveToolingService.openDocument(testFileURL);
        Option<WeaveUnitTestAddition> maybeAddition = this.getTestAddition(testToolingService, documentToolingService, startOffset, endOffset);
        if (maybeAddition.isEmpty()) {
            this.unableToRunTest(testFile, uIService);
            return;
        }
        WeaveUnitTestAddition testAddition = (WeaveUnitTestAddition)maybeAddition.get();
        String testStr = testAddition.test();
        int line = testAddition.replacementLine() - 1;
        ArrayBuffer edits = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (testAddition.needsCommaBefore()) {
            Position commaPosition = testAddition.commaPosition();
            boxedUnit = edits.$plus$eq(this.insertTextEdit(testFileURL, ",", commaPosition.line() - 1, commaPosition.column() - 1));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        edits.$plus$eq(this.insertTextEdit(testFileURL, testStr, line, this.insertTextEdit$default$4()));
        this.applyEdits(workspaceEditService, (Seq<Either<TextDocumentEdit, ResourceOperation>>)edits);
        uIService.openTextDocument(new OpenTextDocumentParams(testFileURL, new Range(new org.eclipse.lsp4j.Position(line, 0), new org.eclipse.lsp4j.Position(line + new StringOps(Predef$.MODULE$.augmentString(testStr)).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CreateUnitTest.$anonfun$addTestToExistingTestCode$1(BoxesRunTime.unboxToChar((Object)x$1)))), 0))));
    }

    private Option<WeaveUnitTestAddition> getTestAddition(WeaveDocumentToolingService testToolingService, WeaveDocumentToolingService documentToolingService, int startOffset, int endOffset) {
        Option maybeAst = testToolingService.ast().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.astNode());
        return maybeAst.flatMap((Function1 & Serializable & scala.Serializable)ast -> documentToolingService.addUnitTestFromDefinition(startOffset, endOffset, ast));
    }

    private Either<TextDocumentEdit, ResourceOperation> insertTextEdit(String testFileURL, String test, int line, int column) {
        org.eclipse.lsp4j.Position position = new org.eclipse.lsp4j.Position(line, column);
        TextEdit textEdit = new TextEdit(new Range(position, position), test);
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(testFileURL, Predef$.MODULE$.int2Integer(0)), Arrays.asList((Object[])new TextEdit[]{textEdit}));
        return Either.forLeft((Object)textDocumentEdit);
    }

    private int insertTextEdit$default$4() {
        return 0;
    }

    private void applyEdits(WorkspaceEditService workspaceEditService, Seq<Either<TextDocumentEdit, ResourceOperation>> edits) {
        java.util.List<Object> editList = Arrays.asList((Object[])edits.toArray(ClassTag$.MODULE$.apply(Either.class)));
        workspaceEditService.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(editList))).get();
    }

    private boolean isBlankFile(File testFile) {
        boolean bl;
        if (!testFile.exists()) {
            return true;
        }
        try (BufferedSource source = Source$.MODULE$.fromFile(testFile, "UTF-8");){
            bl = source.mkString().trim().isEmpty();
        }
        return bl;
    }

    private void unableToRunTest(File testFile, UIService uIService) {
        uIService.showMessage(new MessageParams(MessageType.Error, UserMessages$.MODULE$.invalidTestFileSyntax(testFile)));
    }

    public String name() {
        return "Creates Unit.";
    }

    public String description(ExecuteCommandParams params) {
        return "Creating Unit Test.";
    }

    public static final /* synthetic */ void $anonfun$addTestToBlankFile$1(CreateUnitTest $this, String testFileURL$1, File testFile$1, WorkspaceEditService languageClient$1, UIService weaveLanguageClient$1, String test) {
        Either<TextDocumentEdit, ResourceOperation> insertText = $this.insertTextEdit(testFileURL$1, test, 0, $this.insertTextEdit$default$4());
        Either createFile = Either.forRight((Object)new CreateFile(testFileURL$1));
        Seq edits = !testFile$1.exists() ? (Seq)new .colon.colon((Object)createFile, (List)new .colon.colon(insertText, (List)Nil$.MODULE$)) : (Seq)new .colon.colon(insertText, (List)Nil$.MODULE$);
        $this.applyEdits(languageClient$1, (Seq<Either<TextDocumentEdit, ResourceOperation>>)edits);
        weaveLanguageClient$1.openTextDocument(new OpenTextDocumentParams(testFileURL$1, OpenTextDocumentParams$.MODULE$.apply$default$2()));
    }

    public static final /* synthetic */ boolean $anonfun$addTestToExistingTestCode$1(char x$1) {
        return x$1 == '\n';
    }

    public CreateUnitTest(WorkspaceServiceManager workspaceServiceManager, UIService uIService) {
        this.workspaceServiceManager = workspaceServiceManager;
        this.uIService = uIService;
    }
}

