/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.lsp.utils;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class URLUtils$ {
    public static URLUtils$ MODULE$;

    static {
        new URLUtils$();
    }

    public Option<URI> toURI(String path) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> new URI(path)).toOption();
    }

    public Option<File> toFile(String path) {
        return this.toURI(path).flatMap((Function1 & java.io.Serializable & Serializable)uri -> Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> Paths.get(uri).toFile()).toOption());
    }

    public Option<Path> toPath(String path) {
        return this.toURI(path).flatMap((Function1 & java.io.Serializable & Serializable)uri -> Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> Paths.get(uri.normalize())).toOption());
    }

    public boolean isChildOf(String childUri, File parent) {
        return this.toPath(childUri).exists((Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)URLUtils$.$anonfun$isChildOf$1(parent, path)));
    }

    public boolean isChildOf(String childUri, String parentUri) {
        return BoxesRunTime.unboxToBoolean((Object)this.toPath(childUri).flatMap((Function1 & java.io.Serializable & Serializable)childPath -> MODULE$.toPath(parentUri).map((Function1 & java.io.Serializable & Serializable)parentPath -> BoxesRunTime.boxToBoolean((boolean)URLUtils$.$anonfun$isChildOf$3(childPath, parentPath)))).getOrElse((Function0)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> false));
    }

    public boolean isChildOfAny(String child, File[] parents) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parents)).exists((Function1 & java.io.Serializable & Serializable)parent -> BoxesRunTime.boxToBoolean((boolean)URLUtils$.MODULE$.isChildOf(child, parent)));
    }

    public boolean isDWFile(String uri) {
        return uri.endsWith(".dwl");
    }

    public String toLSPUrl(File theFile) {
        return new StringBuilder(7).append("file://").append(theFile.toURI().toURL().getPath()).toString();
    }

    public String toLSPUrl(String path) {
        return new StringBuilder(7).append("file://").append(path).toString();
    }

    public String uriPath(String canonicalPathReplaced) {
        return new StringBuilder(0).append(canonicalPathReplaced.charAt(0) == '/' ? "" : "/").append(canonicalPathReplaced).toString();
    }

    public String toCanonicalString(String uri) {
        return URI.create(uri).toString();
    }

    public static final /* synthetic */ boolean $anonfun$isChildOf$1(File parent$1, Path path) {
        return path.toAbsolutePath().startsWith(parent$1.toPath());
    }

    public static final /* synthetic */ boolean $anonfun$isChildOf$3(Path childPath$1, Path parentPath) {
        return childPath$1.toAbsolutePath().startsWith(parentPath.toAbsolutePath());
    }

    private URLUtils$() {
        MODULE$ = this;
    }
}

