package org.mule.weave.v2.metadata.api

import org.mule.metadata.api.annotation.TypeAnnotation
import org.mule.weave.v2.ts.Metadata

/**
  * Implement this interface to affect how Weave Type Metadata is handled
  */
trait WeaveTypeMetadataConvert {
  /**
    * Transform a [[Metadata]] to a [[TypeAnnotation]]
    *
    * @param metadata the [[Metadata]] to transform
    * @return the [[TypeAnnotation]] or 'null' if it should be ignored
    */
  def toTypeAnnotation(metadata: Metadata): TypeAnnotation
}
