package org.mule.weave.v2.nocache.cache.service

import org.mule.weave.v2.cache.service.Cache

import java.util.Collections

class NoCache[K, V](provider: Option[K => V]) extends Cache[K, V] {
  override def get(key: K, provider: K => V): V = {
    provider(key)
  }

  override def get(key: K): V = {
    provider match {
      case Some(value) =>
        get(key, value)
      case _ =>
        throw new RuntimeException("No default provider specified")
    }
  }

  override def getIfPresent(key: K): Option[V] = {
    None
  }

  override def asMap(): java.util.Map[K, V] = Collections.emptyMap()
}
