/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.utils;

import java.io.Serializable;
import org.mule.weave.v2.codegen.CodeWriter;
import org.mule.weave.v2.codegen.StringCodeWriter;
import org.mule.weave.v2.parser.ast.QName;
import org.mule.weave.v2.ts.AnyType;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.BinaryType;
import org.mule.weave.v2.ts.BooleanType;
import org.mule.weave.v2.ts.DateTimeType;
import org.mule.weave.v2.ts.DynamicReturnType;
import org.mule.weave.v2.ts.FunctionType;
import org.mule.weave.v2.ts.FunctionTypeParameter;
import org.mule.weave.v2.ts.IntersectionType;
import org.mule.weave.v2.ts.KeyType;
import org.mule.weave.v2.ts.KeyValuePairType;
import org.mule.weave.v2.ts.LocalDateTimeType;
import org.mule.weave.v2.ts.LocalDateType;
import org.mule.weave.v2.ts.LocalTimeType;
import org.mule.weave.v2.ts.NameType;
import org.mule.weave.v2.ts.NameValuePairType;
import org.mule.weave.v2.ts.NamespaceType;
import org.mule.weave.v2.ts.NothingType;
import org.mule.weave.v2.ts.NullType;
import org.mule.weave.v2.ts.NumberType;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.PeriodType;
import org.mule.weave.v2.ts.RangeType;
import org.mule.weave.v2.ts.ReferenceType;
import org.mule.weave.v2.ts.RegexType;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.TimeType;
import org.mule.weave.v2.ts.TimeZoneType;
import org.mule.weave.v2.ts.TypeParameter;
import org.mule.weave.v2.ts.TypeType;
import org.mule.weave.v2.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;

public final class WeaveTypeEmitter$ {
    public static WeaveTypeEmitter$ MODULE$;

    static {
        new WeaveTypeEmitter$();
    }

    public String toString(WeaveType wtype) {
        StringCodeWriter builder = new StringCodeWriter();
        this.generate(wtype, builder);
        return builder.codeContent();
    }

    private void generate(WeaveType wtype, StringCodeWriter builder) {
        block41: {
            while (true) {
                WeaveType weaveType;
                if ((weaveType = wtype) instanceof ObjectType) {
                    BoxedUnit boxedUnit;
                    ObjectType objectType = (ObjectType)weaveType;
                    Seq<KeyValuePairType> properties = objectType.properties();
                    if (properties.isEmpty()) {
                        builder.print("Object");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        builder.print("{");
                        builder.indent();
                        ((IterableLike)properties.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)indexProp -> {
                            WeaveTypeEmitter$.$anonfun$generate$1(this, builder, indexProp);
                            return BoxedUnit.UNIT;
                        });
                        builder.dedent();
                        builder.print("}");
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block41;
                }
                if (weaveType instanceof KeyValuePairType) {
                    KeyValuePairType keyValuePairType = (KeyValuePairType)weaveType;
                    WeaveType key = keyValuePairType.key();
                    WeaveType value = keyValuePairType.value();
                    boolean optional = keyValuePairType.optional();
                    this.generate(key, builder);
                    Object object = optional ? builder.print("?") : BoxedUnit.UNIT;
                    builder.printSpace(":");
                    wtype = value;
                    continue;
                }
                if (weaveType instanceof KeyType) {
                    BoxedUnit boxedUnit;
                    KeyType keyType = (KeyType)weaveType;
                    WeaveType name = keyType.name();
                    Seq<NameValuePairType> attrs = keyType.attrs();
                    this.generate(name, builder);
                    if (attrs.nonEmpty()) {
                        builder.print(" @(");
                        ((IterableLike)attrs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)attr -> {
                            WeaveTypeEmitter$.$anonfun$generate$2(this, builder, attr);
                            return BoxedUnit.UNIT;
                        });
                        builder.print(")");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                    break block41;
                }
                if (weaveType instanceof NameValuePairType) {
                    NameValuePairType nameValuePairType = (NameValuePairType)weaveType;
                    WeaveType name = nameValuePairType.name();
                    WeaveType value = nameValuePairType.value();
                    this.generate(name, builder);
                    builder.print(": ");
                    wtype = value;
                    continue;
                }
                if (weaveType instanceof NameType) {
                    NameType nameType = (NameType)weaveType;
                    Option<QName> name = nameType.value();
                    Option<QName> option = name;
                    if (option instanceof Some) {
                        Object object;
                        Some some = (Some)option;
                        QName qName = (QName)some.value();
                        if (qName.ns().isDefined()) {
                            builder.print((String)qName.ns().get());
                            object = builder.print("#");
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        builder.print(qName.name());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        builder.print("Name");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)weaveType;
                    WeaveType of = arrayType.of();
                    builder.print("Array<");
                    this.generate(of, builder);
                    builder.print(">");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof UnionType) {
                    UnionType unionType = (UnionType)weaveType;
                    Seq<WeaveType> of = unionType.of();
                    ((IterableLike)of.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                        WeaveTypeEmitter$.$anonfun$generate$3(this, builder, item);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof IntersectionType) {
                    IntersectionType intersectionType = (IntersectionType)weaveType;
                    Seq<WeaveType> of = intersectionType.of();
                    ((IterableLike)of.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                        WeaveTypeEmitter$.$anonfun$generate$4(this, builder, item);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof StringType) {
                    builder.print("String");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof AnyType) {
                    builder.print("Any");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof BooleanType) {
                    builder.print("Boolean");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof NumberType) {
                    builder.print("Number");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof RangeType) {
                    builder.print("Range");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof RegexType) {
                    builder.print("Regex");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof NullType) {
                    builder.print("Null");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof DateTimeType) {
                    builder.print("DateTime");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof LocalDateTimeType) {
                    builder.print("LocalDateTime");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof LocalDateType) {
                    builder.print("LocalDate");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof LocalTimeType) {
                    builder.print("LocalTime");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof TimeType) {
                    builder.print("Time");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof TimeZoneType) {
                    builder.print("TimeZone");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof PeriodType) {
                    builder.print("Period");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof BinaryType) {
                    builder.print("Binary");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof TypeParameter) {
                    TypeParameter typeParameter = (TypeParameter)weaveType;
                    String name = typeParameter.name();
                    Option<WeaveType> bt = typeParameter.baseType();
                    builder.print(name);
                    if (bt.isDefined()) {
                        builder.print(" is ");
                        wtype = (WeaveType)bt.get();
                        continue;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof FunctionType) {
                    FunctionType functionType = (FunctionType)weaveType;
                    Seq<FunctionTypeParameter> args = functionType.params();
                    WeaveType returnType = functionType.returnType();
                    builder.print("(");
                    ((IterableLike)args.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                        WeaveTypeEmitter$.$anonfun$generate$5(this, builder, item);
                        return BoxedUnit.UNIT;
                    });
                    builder.printSpace(")");
                    builder.printSpace("=>");
                    wtype = returnType;
                    continue;
                }
                if (weaveType instanceof TypeType) {
                    TypeType typeType = (TypeType)weaveType;
                    WeaveType t = typeType.t();
                    builder.print("Type<");
                    this.generate(t, builder);
                    builder.print(">");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof NothingType) {
                    builder.print("Nothing");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof NamespaceType) {
                    builder.print("Namespace");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (weaveType instanceof DynamicReturnType) {
                    builder.print("Undefined");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block41;
                }
                if (!(weaveType instanceof ReferenceType)) break;
                ReferenceType referenceType = (ReferenceType)weaveType;
                wtype = referenceType.resolveType();
            }
            builder.print(wtype.getClass().getSimpleName());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CodeWriter printQName(StringCodeWriter builder, QName name) {
        return builder.print(name.name());
    }

    public static final /* synthetic */ void $anonfun$generate$1(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 indexProp) {
        Object object = indexProp._2$mcI$sp() > 0 ? builder$1.printSpace(",") : BoxedUnit.UNIT;
        $this.generate((WeaveType)indexProp._1(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$2(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 attr) {
        Object object = attr._2$mcI$sp() > 0 ? builder$1.printSpace(",") : BoxedUnit.UNIT;
        $this.generate((WeaveType)attr._1(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$3(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 item) {
        Object object = item._2$mcI$sp() > 0 ? builder$1.print(" | ") : BoxedUnit.UNIT;
        $this.generate((WeaveType)item._1(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$4(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 item) {
        Object object = item._2$mcI$sp() > 0 ? builder$1.print(" & ") : BoxedUnit.UNIT;
        $this.generate((WeaveType)item._1(), builder$1);
    }

    public static final /* synthetic */ void $anonfun$generate$5(WeaveTypeEmitter$ $this, StringCodeWriter builder$1, Tuple2 item) {
        Object object = item._2$mcI$sp() > 0 ? builder$1.print(", ") : BoxedUnit.UNIT;
        builder$1.print(((FunctionTypeParameter)item._1()).name()).printSpace(":");
        $this.generate(((FunctionTypeParameter)item._1()).wtype(), builder$1);
    }

    private WeaveTypeEmitter$() {
        MODULE$ = this;
    }
}

