package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.MetadataAnnotationShouldHaveValue
import org.mule.weave.v2.parser.annotation.MetadataKeyAstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode

class MetadataAnnotationProcessorScopePhase extends AbstractCanonicalAnnotationProcessor {

  /**
    * Run the annotation processing logic on the scope navigation phase
    */
  override def run(annotatedNode: AstNode, annotation: AnnotationNode, context: CanonicalPhaseAnnotationContext): Unit = {
    MetadataAnnotationProcessor.runProcessor(annotatedNode, annotation, context)
  }

}

object MetadataAnnotationProcessor {
  def runProcessor(annotatedNode: AstNode, annotation: AnnotationNode, context: AnnotationContext): Unit = {
    annotatedNode match {
      case annotationDirective: AnnotationDirectiveNode => {
        val paramList = annotationDirective.params.paramList
        val value = "value"
        if (paramList.size != 1) {
          context.messageCollector.error(MetadataAnnotationShouldHaveValue(None, Some(paramList.size)), annotationDirective.location())
        } else if (!paramList.head.nameIdentifier.name.equals(value)) {
          val head = paramList.head
          context.messageCollector.error(MetadataAnnotationShouldHaveValue(Some(head.nameIdentifier), None), head.location())
        } else {
          AnnotationNodeHelper
            .argString("key", annotation)
            .map(keyName => {
              annotationDirective.annotate(new MetadataKeyAstNodeAnnotation(keyName))
            })
        }
      }
    }
  }
}

class MetadataAnnotationProcessorParsingPhase extends AbstractParsingAnnotationProcessor {

  /**
    * Run the annotation processing logic on the scope navigation phase
    */
  override def run(annotatedNode: AstNode, annotation: AnnotationNode, context: ParsingPhaseAnnotationContext): Unit = {
    MetadataAnnotationProcessor.runProcessor(annotatedNode, annotation, context)
  }
}
