package org.mule.weave.v2.codegen
import org.mule.weave.v2.parser.ast.AstNode

trait CodeWriter {
  def nonEmpty(): Boolean

  def println(code: String): CodeWriter

  def println(): CodeWriter

  def print(code: String): CodeWriter

  def print(code: Char): CodeWriter

  def printQuoted(text: String): CodeWriter

  def printForeachWithSeparator[A <: AstNode](separator: String, elements: Seq[A], code: (A) => Unit): CodeWriter

  def printSpace(code: String): CodeWriter

  def printSpace(): CodeWriter

  def printIndent(): CodeWriter

  def indent(): CodeWriter

  def dedent(): CodeWriter

  def onNewLine(callback: (CodeWriter) => Unit): CodeWriter

  def hasNewLineListener(): Boolean

}
