package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.FunctionInvalidDefaultValueMessage
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.functions.FunctionParameter

/**
  * Validates two variables doesn't have the same name
  */
class FunctionDefaultValueLocationValidation extends AstNodeVerifier {
  override def verify(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case FunctionNode(params, _, _, _) => {
        if (params.paramList.nonEmpty) {
          val paramList: Seq[FunctionParameter] = params.paramList
          if (paramList.head.defaultValue.isDefined) {
            //Head default parameters
            val parameters: Iterator[FunctionParameter] = paramList.iterator
            var withDefaultValue = true
            while (parameters.hasNext && withDefaultValue) {
              val parameter: FunctionParameter = parameters.next()
              withDefaultValue = parameter.defaultValue.isDefined
            }
            val maybeParameter: Option[FunctionParameter] = parameters.find((param) => param.defaultValue.isDefined)
            if (maybeParameter.isDefined) {
              context.messageCollector.error(FunctionInvalidDefaultValueMessage(), maybeParameter.get.location())
            }
          } else {
            val parameters: Iterator[FunctionParameter] = paramList.iterator
            val maybeParameter: Option[FunctionParameter] = parameters.find((param) => param.defaultValue.isDefined)
            if (maybeParameter.isDefined) {
              val withNoDefaultValue: Option[FunctionParameter] = parameters.find((param) => param.defaultValue.isEmpty)
              if (withNoDefaultValue.isDefined) {
                context.messageCollector.error(FunctionInvalidDefaultValueMessage(), withNoDefaultValue.get.location())
              }
            }
          }
        }
      }
      case _ =>
    }
  }

}
