package org.mule.weave.v2.api.tooling.impl.message

import org.mule.weave.v2.api.tooling.message.Message
import org.mule.weave.v2.api.tooling.message.MessageBuilder
import org.mule.weave.v2.parser.DefaultMessage
import org.mule.weave.v2.parser.MessageCategory

import java.util.Objects.requireNonNull

class DefaultMessageBuilder extends MessageBuilder {

  private var kind: String = _
  private var message: String = _

  override def withKind(kind: String): MessageBuilder = {
    this.kind = kind
    this
  }

  override def withMessage(message: String): MessageBuilder = {
    this.message = message
    this
  }

  override def build(): Message = {
    requireNonNull(kind, "Message 'kind' must not be null.")
    requireNonNull(message, "Message 'message' must not be null.")
    new DefaultMessage(kind, message, ToolingPhaseCategory)
  }
}

object ToolingPhaseCategory extends MessageCategory {
  override def name: String = "Tooling"
}