/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.BinaryWeaveResource;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver$;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.utils.WeaveConstants$;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\n\u0015\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\r\u0002!\te\u0012\u0005\u00065\u0002!\te\u0017\u0005\u0006C\u0002!\tE\u0019\u0005\u0006[\u0002!\tE\u001c\u0005\u0006a\u0002!I!\u001d\u0005\u0006{\u0002!IA \u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\u0006\u0001\t\u0003\t9bB\u0004\u0002\u001cQA\t!!\b\u0007\rM!\u0002\u0012AA\u0010\u0011\u0019\u0011U\u0002\"\u0001\u0002\"!9\u00111E\u0007\u0005\u0002\u0005\u0015\u0002bBA\u0014\u001b\u0011\u0005\u0011Q\u0005\u0005\b\u0003SiA\u0011AA\u0013\u0011\u001d\tY#\u0004C\u0001\u0003[\u0011\u0001e\u00117bgNdu.\u00193fe^+\u0017M^3SKN|WO]2f%\u0016\u001cx\u000e\u001c<fe*\u0011QCF\u0001\u0004g\u0012\\'BA\f\u0019\u0003\t1(G\u0003\u0002\u001a5\u0005)q/Z1wK*\u00111\u0004H\u0001\u0005[VdWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dBS\"\u0001\u000b\n\u0005%\"\"!F,fCZ,'+Z:pkJ\u001cWMU3t_24XM]\u0001\rG2\f7o\u001d7pC\u0012,'o\u001d\t\u0004YQ:dBA\u00173\u001d\tq\u0013'D\u00010\u0015\t\u0001d$\u0001\u0004=e>|GOP\u0005\u0002G%\u00111GI\u0001\ba\u0006\u001c7.Y4f\u0013\t)dGA\u0002TKFT!a\r\u0012\u0011\u0007\u0005B$(\u0003\u0002:E\tIa)\u001e8di&|g\u000e\r\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005-\u0019E.Y:t\u0019>\fG-\u001a:\u0002\rqJg.\u001b;?)\t!U\t\u0005\u0002(\u0001!)!F\u0001a\u0001W\u00059!/Z:pYZ,GC\u0001%O!\r\t\u0013jS\u0005\u0003\u0015\n\u0012aa\u00149uS>t\u0007CA\u0014M\u0013\tiECA\u0007XK\u00064XMU3t_V\u00148-\u001a\u0005\u0006\u001f\u000e\u0001\r\u0001U\u0001\u0005]\u0006lW\r\u0005\u0002R16\t!K\u0003\u0002T)\u0006Ia/\u0019:jC\ndWm\u001d\u0006\u0003+Z\u000b1!Y:u\u0015\t9f#\u0001\u0004qCJ\u001cXM]\u0005\u00033J\u0013aBT1nK&#WM\u001c;jM&,'/A\u0007sKN|GN^3CS:\f'/\u001f\u000b\u00039\u0002\u00042!I%^!\t9c,\u0003\u0002`)\t\u0019\")\u001b8bef<V-\u0019<f%\u0016\u001cx.\u001e:dK\")q\n\u0002a\u0001!\u0006Y!/Z:pYZ,\u0007+\u0019;i)\tA5\rC\u0003e\u000b\u0001\u0007Q-\u0001\u0003qCRD\u0007C\u00014k\u001d\t9\u0007\u000e\u0005\u0002/E%\u0011\u0011NI\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002jE\u0005\t\"/Z:pYZ,')\u001b8bef\u0004\u0016\r\u001e5\u0015\u0005q{\u0007\"\u00023\u0007\u0001\u0004)\u0017!\u0006;p/\u0016\fg/Z*pkJ\u001cWMU3t_V\u00148-\u001a\u000b\u0003eV\u0004\"aJ:\n\u0005Q$\"\u0001\u0006#fM\u0006,H\u000e^,fCZ,'+Z:pkJ\u001cW\rC\u0003w\u000f\u0001\u0007q/A\u0004fY\u0016lWM\u001c;\u0011\u0005a\\X\"A=\u000b\u0005it\u0014a\u00018fi&\u0011A0\u001f\u0002\u0004+Jc\u0015!\u0006;p/\u0016\fg/\u001a\"j]\u0006\u0014\u0018PU3t_V\u00148-\u001a\u000b\u0005;~\f\t\u0001C\u0003w\u0011\u0001\u0007q\u000f\u0003\u0004\u0002\u0004!\u0001\raS\u0001\u0014g>,(oY3XK\u00064XMU3t_V\u00148-Z\u0001\u000be\u0016\u001cx\u000e\u001c<f+JdG\u0003BA\u0005\u0003\u0017\u00012!I%x\u0011\u0015!\u0017\u00021\u0001f\u0003)\u0011Xm]8mm\u0016\fE\u000e\u001c\u000b\u0005\u0003#\t\u0019\u0002E\u0002-i-CQa\u0014\u0006A\u0002A\u000bq\u0002\\8pWV\u0004(+Z:pkJ\u001cWm\u001d\u000b\u0005\u0003#\tI\u0002C\u0003e\u0017\u0001\u0007Q-\u0001\u0011DY\u0006\u001c8\u000fT8bI\u0016\u0014x+Z1wKJ+7o\\;sG\u0016\u0014Vm]8mm\u0016\u0014\bCA\u0014\u000e'\ti\u0001\u0005\u0006\u0002\u0002\u001e\u0005)\u0011\r\u001d9msR\tA)\u0001\u000bo_\u000e{g\u000e^3yi\u000ec\u0017m]:m_\u0006$WM]\u0001\u0017G>tG/\u001a=u\u00072\f7o\u001d7pC\u0012,'o\u00148ms\u0006\u0019\u0002O]8wS\u0012,Gm\u00117bgNdu.\u00193feR\u0019A)a\f\t\u000f\u0005E\"\u00031\u0001\u00024\u0005a1\r\\1tg2{\u0017\rZ3sgB\u0019A\u0006\u000e\u001e")
public class ClassLoaderWeaveResourceResolver
implements WeaveResourceResolver {
    private final Seq<Function0<ClassLoader>> classloaders;

    public static ClassLoaderWeaveResourceResolver providedClassLoader(Seq<ClassLoader> seq) {
        return ClassLoaderWeaveResourceResolver$.MODULE$.providedClassLoader(seq);
    }

    public static ClassLoaderWeaveResourceResolver contextClassloaderOnly() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.contextClassloaderOnly();
    }

    public static ClassLoaderWeaveResourceResolver noContextClassloader() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.noContextClassloader();
    }

    public static ClassLoaderWeaveResourceResolver apply() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.apply();
    }

    @Override
    public Option<WeaveResource> resolve(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, "/");
        return this.resolvePath(path);
    }

    @Override
    public Option<BinaryWeaveResource> resolveBinary(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveBinaryFilePath(name, "/");
        return this.resolveBinaryPath(path);
    }

    @Override
    public Option<WeaveResource> resolvePath(String path) {
        return this.resolveUrl(path).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveSourceResource((URL)url));
    }

    @Override
    public Option<BinaryWeaveResource> resolveBinaryPath(String path) {
        Option maybeSourceWeaveResource = this.resolveUrl(path.replace(WeaveFile$.MODULE$.binaryFileExtension(), WeaveFile$.MODULE$.fileExtension())).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveSourceResource((URL)url));
        return maybeSourceWeaveResource.flatMap((Function1 & Serializable & scala.Serializable)sourceWeaveResource -> this.resolveUrl(path).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveBinaryResource((URL)url, (WeaveResource)sourceWeaveResource)));
    }

    private DefaultWeaveResource toWeaveSourceResource(URL element) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(element.openStream(), WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(element.toExternalForm(), source.mkString());
        }
        return defaultWeaveResource;
    }

    private BinaryWeaveResource toWeaveBinaryResource(URL element, WeaveResource sourceWeaveResource) {
        return WeaveResourceFactory$.MODULE$.fromBinaryInputStream(element.openStream(), sourceWeaveResource);
    }

    private Option<URL> resolveUrl(String path) {
        String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        while (classLoadersIt.hasNext() && !resources.hasMoreElements()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
        }
        if (resources.hasMoreElements()) {
            return Option$.MODULE$.apply(resources.nextElement());
        }
        return None$.MODULE$;
    }

    @Override
    public Seq<WeaveResource> resolveAll(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, "/");
        return this.lookupResources(path);
    }

    public Seq<WeaveResource> lookupResources(String path) {
        String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (classLoadersIt.hasNext()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
            result.$plus$plus$eq((TraversableOnce)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(resources).asScala()).map((Function1 & Serializable & scala.Serializable)resource -> {
                DefaultWeaveResource defaultWeaveResource;
                try (BufferedSource source = Source$.MODULE$.fromInputStream(resource.openStream(), "UTF-8");){
                    defaultWeaveResource = WeaveResource$.MODULE$.apply(resource.toExternalForm(), source.mkString());
                }
                return defaultWeaveResource;
            }));
        }
        return result;
    }

    public ClassLoaderWeaveResourceResolver(Seq<Function0<ClassLoader>> classloaders) {
        this.classloaders = classloaders;
        WeaveResourceResolver.$init$(this);
    }
}

