package org.mule.weave.v2.parser.annotation

case class BooleanNotTypeAnnotation(notType: NotType) extends WithValueAstNodeAnnotation[NotType] with EphemeralAstNodeAnnotation {
  override def name(): String = "notType"
  override def value(): NotType = notType
}

sealed trait NotType {
  val kind: String
}
object NotType {
  case object Exclamation extends NotType {
    val kind = "Exclamation"
  }
  case object Word extends NotType {
    val kind = "Word"
  }
}