package org.mule.weave.v2.parser.phase.metrics

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.CompilationPhase
import org.mule.weave.v2.parser.phase.CompositeCompilationPhase
import org.mule.weave.v2.parser.phase.EnrichedCompilationPhase
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationListener
import org.mule.weave.v2.sdk.{ BinaryWeaveResource, WeaveResource, WeaveResourceResolver }

import scala.collection.mutable

class ParsingMetricsCollectorListener(printLive: Boolean = false) extends ParsingNotificationListener {

  private var currentParsingMetric: ParsingPhaseMetric = new ParsingPhaseMetric(null, null, None)
  private var currentCompileMetric: CompilationPhaseMetrics = new CompilationPhaseMetrics(null, None)

  private val resourceMetrics: mutable.ArrayBuffer[ResourceMetrics] = mutable.ArrayBuffer()

  def metrics(): CompilationMetrics = {
    new CompilationMetrics(currentParsingMetric.childrenMetrics(), currentCompileMetric.childrenMetrics(), resourceMetrics.toArray)
  }

  override def endPhase(nameIdentifier: NameIdentifier, phase: CompilationPhase[_, _], result: PhaseResult[_]): Unit = {
    if (ignorePhase(phase))
      return
    this.currentParsingMetric.endPhase()
    this.currentParsingMetric = currentParsingMetric.parent.getOrElse(currentParsingMetric)
    if (printLive) {
      this.currentParsingMetric.print()
    }
  }

  override def startCompilation(nameIdentifier: NameIdentifier): Unit = {
    val phaseMetric = this.currentCompileMetric.child(nameIdentifier)
    phaseMetric.startCompilation()
    this.currentCompileMetric = phaseMetric
  }

  override def endCompilation(nameIdentifier: NameIdentifier, cached: Boolean, result: Option[Any]): Unit = {
    this.currentCompileMetric.endCompilation(cached)
    this.currentCompileMetric = currentCompileMetric.parent.getOrElse(this.currentCompileMetric)
    if (printLive) {
      this.currentCompileMetric.print()
    }
  }

  override def startPhase(nameIdentifier: NameIdentifier, value: CompilationPhase[_, _]): Unit = {
    if (ignorePhase(value))
      return
    val phaseMetric = this.currentParsingMetric.child(nameIdentifier, value)
    phaseMetric.startPhase()
    this.currentParsingMetric = phaseMetric
  }

  private def ignorePhase(value: CompilationPhase[_, _]) = {
    value.isInstanceOf[CompositeCompilationPhase[_, _, _]] || value.isInstanceOf[EnrichedCompilationPhase[_, _]]
  }

  override def endResolvingResource(nameIdentifier: NameIdentifier, extension: String, resourceResolver: WeaveResourceResolver, result: Option[WeaveResource]): Unit = {
    this.resourceMetrics.lastOption.foreach((m) => {
      m.endFetch(result.map(_.content().length).getOrElse(0), extension)
    })
  }

  override def startResolvingResource(nameIdentifier: NameIdentifier, weaveResourceResolver: WeaveResourceResolver): Unit = {
    val rm = new ResourceMetrics(nameIdentifier, weaveResourceResolver)
    rm.startFetch()
    this.resourceMetrics.+=(rm)
  }

  override def progress(): Unit = {}
}
