package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.ArrayType
import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

object HeadTailArrayTypeResolver extends WeaveTypeResolver {

  override def supportsPartialResolution() = true

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val headType = headEdge(node).mayBeIncomingType()
    val tailType = tailEdge(node).mayBeIncomingType()
    if (headType.isDefined && tailType.isEmpty) {
      Some(ArrayType(headType.get))
    } else if (tailType.isDefined && headType.isEmpty) {
      tailType
    } else if (tailType.isDefined && headType.isDefined) {
      tailType.get match {
        case ArrayType(t) => Some(ArrayType(TypeHelper.unify(Seq(headType.get, t))))
        case _            => Some(ArrayType(headType.get))
      }
    } else {
      None
    }
  }

  private def tailEdge(node: TypeNode) = {
    node.incomingEdges(EdgeLabels.TAIL).head
  }

  private def headEdge(node: TypeNode) = {
    node.incomingEdges(EdgeLabels.HEAD).head
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    incomingExpectedType match {
      case Some(arrayType: ArrayType) => {
        Seq(
          (headEdge(node), arrayType.of),
          (tailEdge(node), arrayType))
      }
      case _ => Seq()
    }
  }
}
