package org.mule.weave.v2.parser.ast.functions

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Child
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

case class UsingNode(assignments: UsingVariableAssignments, expr: AstNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode {
  override def children(): Seq[AstNode] = Children(assignments, expr).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = {
    copy(assignments.cloneAst(), expr.cloneAst(), codeAnnotations.map(_.cloneAst()))
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.USING_NODE
}

case class UsingVariableAssignments(assignmentSeq: Seq[UsingVariableAssignment]) extends AstNode {

  override def cloneAst(): UsingVariableAssignments = super.cloneAst().asInstanceOf[UsingVariableAssignments]

  override def children(): Seq[AstNode] = assignmentSeq

  override protected def doClone(): AstNode = {
    copy(assignmentSeq.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.USING_VARIABLE_ASSIGNMENTS_NODE
}

case class UsingVariableAssignment(name: NameIdentifier, value: AstNode) extends AstNode {
  override def children(): Seq[AstNode] = Child(name, value)

  override def cloneAst(): UsingVariableAssignment = super.cloneAst().asInstanceOf[UsingVariableAssignment]

  override protected def doClone(): AstNode = {
    copy(name.cloneAst(), value.cloneAst())
  }

  override def getKind(): String = DWAstNodeKind.USING_VARIABLE_ASSIGNMENT_NODE
}
