package org.mule.weave.v2.imports

import org.mule.weave.v2.parser.UnusedImportElement
import org.mule.weave.v2.parser.UnusedImportModule
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.phase.AstNodeResultAware
import org.mule.weave.v2.parser.phase.CompilationPhase
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.parser.phase.ScopeNavigatorResultAware
import org.mule.weave.v2.parser.phase.SuccessResult
import org.mule.weave.v2.parser.phase.VerificationPhase
import org.mule.weave.v2.scope.ImportInformationResult

class UnusedImportsPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware] extends VerificationPhase[R, T] {

  override def verify(source: T, context: ParsingContext): Unit = {
    val result: ImportInformationResult = source.scope.importInformation()
    result.importsInformation().foreach((im) => {
      im.importedElements().foreach((ie) => {
        if (im.isModuleNotUsed() || ie.isImportNotUsed()) {
          context.messageCollector.warning(UnusedImportModule(ie.importDirective), ie.importDirective.location())
        } else {
          val unusedElement = ie.unused_element
          unusedElement.foreach((ue) => {
            context.messageCollector.warning(UnusedImportElement(ie.importDirective, ue), ue.location())
          })
        }
      })
    })
  }

}
