package org.mule.weave.v2.grammar.literals

import org.mule.weave.v2.grammar.Grammar
import org.mule.weave.v2.grammar.Tokens
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast.structure.UriNode
import org.parboiled2._

trait UriLiteral extends PositionTracking with Tokens with StringBuilding with StringLiteral {
  this: UriLiteral with Grammar =>

  val createUriNode = (n: String) => {
    UriNode(n)
  }

  def uri: Rule1[UriNode] = namedRule("Uri") {
    atomic(pushPosition ~ (clearSB() ~ zeroOrMore(!endOfUri ~ ANY ~ appendSB()) ~ push(sb.toString) ~> createUriNode) ~ injectPosition)
  }

  def endOfUri: Rule0 = rule {
    quiet(oneOrMore(whiteSpaceOrNewLineChar))
  }

}
