package org.mule.weave.v2.parser.phase.metrics

import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import scala.collection.mutable

class CompilationPhaseMetrics(val nameIdentifier: NameIdentifier, val parent: Option[CompilationPhaseMetrics], val indent: Int = 0) {

  val compilation: TimeMetric = new TimeMetric()
  var cached: Boolean = false
  private val children: mutable.ArrayBuffer[CompilationPhaseMetrics] = mutable.ArrayBuffer[CompilationPhaseMetrics]()

  def print(): Unit = {
    println(s"|${"--|" * indent}[${nameIdentifier}] took ${compilation.duration()} ms [cached: ${cached}]")
    children.foreach((c) => {
      c.print()
    })
  }

  def child(nameIdentifier: NameIdentifier): CompilationPhaseMetrics = {
    val metric = new CompilationPhaseMetrics(nameIdentifier, Some(this), indent + 1)
    children.+=(metric)
    metric
  }

  def childrenMetrics(): Array[CompilationPhaseMetrics] = {
    children.toArray
  }

  def startCompilation(): Unit = {
    compilation.start()
  }

  def endCompilation(cached: Boolean): Unit = {
    compilation.end()
    this.cached = cached
  }
}
