package org.mule.weave.v2.editor

/**
  * A quick fix action that fixes some problem
  */
trait CodeRefactor {

  /**
    * The requested parameters to the user for this Refactor to be executed
    *
    * @return The list of all the parameters
    */
  def parameters(): Array[RefactorParameter]

  /**
    * Runs the quick fix on this document
    *
    * @param document The document
    * @param arguments The arguments that the user set to invoke this refactor
    */
  def run(document: WeaveTextDocument, arguments: Map[String, Any]): Unit
}

case class RefactorParameter(name: String, defaultValue: String, title: String)