package org.mule.weave.v2.utils

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.NamedAstNode
import org.mule.weave.v2.parser.ast.selectors.NullSafeNode
import org.mule.weave.v2.parser.ast.selectors.NullUnSafeNode
import org.mule.weave.v2.parser.ast.structure.KeyNode
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode
import org.mule.weave.v2.parser.ast.structure.NameNode
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.types.KeyTypeNode
import org.mule.weave.v2.parser.ast.types.KeyValueTypeNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.scope.AstNavigator
import org.mule.weave.v2.scope.VariableScope

import scala.collection.mutable

object WeaveNameHelper {

  def inferVariableName(nodeToExtract: AstNode, navigator: AstNavigator, defaultSuffix: String, vs: VariableScope): String = {
    val name = nodeToExtract match {
      //If string is longer than 32 characters then it doesn't make sense to infere the variable name out of the string character
      case sn: StringNode if (sn.literalValue.length < 32) => WeaveNameHelper.toValidNameIdentifier(sn.value) + defaultSuffix
      case NullSafeNode(node, _)                           => inferVariableName(AstNodeHelper.lastNode(node), navigator, defaultSuffix, vs)
      case NullUnSafeNode(node, _)                         => inferVariableName(AstNodeHelper.lastNode(node), navigator, defaultSuffix, vs)
      case NameNode(keyName, _, _)                         => inferVariableName(keyName, navigator, defaultSuffix, vs)

      case wt: WeaveTypeNode => {
        val maybeKeyValuePair = navigator.parentWithType(wt, classOf[KeyValueTypeNode])
        maybeKeyValuePair match {
          case Some(KeyValueTypeNode(KeyTypeNode(name, _, _, _, _), _, _, _)) if (name.localName.isDefined) => {
            name.localName.get.capitalize + "Type"
          }
          case None => {
            val maybeParameter = navigator.parentWithType(wt, classOf[NamedAstNode])
            maybeParameter match {
              case Some(parameter) => {
                parameter.nameIdentifier.name.capitalize + "Type"
              }
              case _ => "MyType"
            }
          }
        }
      }
      case node => {
        val maybeKeyValuePairNode = navigator.parentWithType(node, classOf[KeyValuePairNode])
        maybeKeyValuePairNode match {
          case Some(KeyValuePairNode(KeyNode(stringNode: StringNode, _, _, _), _, _)) => {
            WeaveNameHelper.toValidNameIdentifier(stringNode.value) + defaultSuffix
          }
          case _ => s"my${defaultSuffix}"
        }

      }
    }

    var uniqueName = name
    val identifiers = vs.declarations
    var i = 0
    while (identifiers.exists(_.name.equals(uniqueName))) {
      uniqueName = name + i
      i = i + 1
    }
    uniqueName
  }

  def toValidNameIdentifier(stringValue: String, keepCapitalized: Boolean): String = {
    val result = mutable.ArrayBuffer[String]()
    var currentWord = new StringBuffer
    var prevIsUpperCase = false
    for (i <- 0 until stringValue.length) {
      val c = stringValue.charAt(i)
      if (Character.isUpperCase(c)) {
        if (currentWord.length > 0 && !prevIsUpperCase) {
          result.+=(currentWord.toString)
          currentWord = new StringBuffer
        }
        if (currentWord.length() == 0 && result.isEmpty && !keepCapitalized) {
          currentWord.append(c.toLower)
        } else {
          currentWord.append(c)
        }
      } else if (Character.isLowerCase(c)) {
        currentWord.append(c)
      } else if (Character.isJavaIdentifierPart(c) && c != '$' && c != '_') {
        if (currentWord.length > 0 || result.nonEmpty) {
          currentWord.append(c)
        } else if (currentWord.length > 0) {
          result.+=(currentWord.toString)
          currentWord = new StringBuffer
        }
      }
      prevIsUpperCase = Character.isUpperCase(c)
    }
    if (currentWord.length > 0) {
      result.+=(currentWord.toString)
    }

    result.mkString("")
  }

  def toValidNameIdentifier(stringValue: String): String = {
    toValidNameIdentifier(stringValue, false)
  }

}
