package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ast.AstNode

class AstNodeTransformationPhase[R <: AstNode, T <: AstNodeResultAware[R]](transformers: Array[AstNodeTransformer]) extends CompilationPhase[T, T] {

  private def doTransform(node: AstNode, ctx: ParsingContext): Unit = {
    var i = 0
    while (i < transformers.length) {
      transformers(i).transform(node, ctx)
      i = i + 1
    }
  }

  private def traverse(node: AstNode, ctx: ParsingContext): Unit = {
    doTransform(node, ctx)
    val nodes = node.children()
    var i = 0
    while (i < nodes.length) {
      traverse(nodes(i), ctx)
      i = i + 1
    }
  }

  override def doCall(source: T, context: ParsingContext): PhaseResult[T] = {
    traverse(source.astNode, context)
    SuccessResult(source, context)
  }
}
