package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.grammar.MetadataAdditionOpId
import org.mule.weave.v2.parser.annotation.InjectedNodeAnnotation
import org.mule.weave.v2.parser.annotation.MetadataAnnotationSchemaAnnotation
import org.mule.weave.v2.parser.annotation.MetadataKeyValueAstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.MutableAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.structure.schema.SchemaNode
import org.mule.weave.v2.parser.ast.structure.schema.SchemaPropertyNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNodeWithSchema
import org.mule.weave.v2.scope.ScopesNavigator

class MetadataTypeNodeInjectorPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware]() extends CompilationPhase[T, T] {

  var mutated = false

  override def doCall(source: T, context: ParsingContext): PhaseResult[_ <: T] = {
    val functionCallNodes: Seq[AnnotationCapableNode] = AstNodeHelper.collectChildren(source.astNode, {
      case annotationCapableNode: AnnotationCapableNode if annotationCapableNode.isAnnotatedWith(classOf[MetadataKeyValueAstNodeAnnotation]) => true
      case _ => false
    }).asInstanceOf[Seq[AnnotationCapableNode]]
    functionCallNodes.foreach(injectTypeNode(_, source.scope))
    if (mutated) {
      source.scope.invalidate()
    }
    SuccessResult(source, context)
  }

  private def injectTypeNode(annotationCapableNode: AnnotationCapableNode, navigator: ScopesNavigator) = {
    val annotations = annotationCapableNode.annotationsBy(classOf[MetadataKeyValueAstNodeAnnotation])
    annotationCapableNode match {
      case weaveTypeNodeWithSchema: WeaveTypeNodeWithSchema => {
        weaveTypeNodeWithSchema.asTypeSchema match {
          case None => {
            val schemaPropertyNodes = annotations.map(annotation => {
              val value = annotation.value()
              SchemaPropertyNode(StringNode(value.metadataKey), value.metadataValue, None).annotate(InjectedNodeAnnotation())
            })
            if (schemaPropertyNodes.nonEmpty) {
              weaveTypeNodeWithSchema.withTypeSchema(SchemaNode(schemaPropertyNodes).annotate(MetadataAnnotationSchemaAnnotation()).annotate(InjectedNodeAnnotation()))
            }
          }
          case _ =>
        }
      }
      case other: AnnotationCapableNode => {
        val schemaPropertyNodes = annotations.map(annotation => {
          val value = annotation.value()
          SchemaPropertyNode(StringNode(value.metadataKey), value.metadataValue, None).annotate(InjectedNodeAnnotation())
        })
        if (schemaPropertyNodes.nonEmpty) {
          val maybeNode = navigator.rootScope.astNavigator().parentOf(other)
          maybeNode match {
            case Some(node: MutableAstNode) => {
              mutated = true
              node.update(other, BinaryOpNode(MetadataAdditionOpId, other, SchemaNode(schemaPropertyNodes).annotate(MetadataAnnotationSchemaAnnotation()).annotate(InjectedNodeAnnotation())).annotate(InjectedNodeAnnotation()))
            }
            case _ =>
          }
        }
      }
    }
  }
}
