package org.mule.weave.v2.parser.exception

import org.mule.weave.v2.annotations.WeaveApi
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation

@WeaveApi(Seq("data-weave-agent"))
trait LocatableException extends WeaveException {

  def location: Location

  def formatErrorLine: String = location.locationString

  def message: String

  override final def getMessage: String = {
    val msg = location match {
      case UnknownLocation   => message
      case wl: WeaveLocation => message + "\n" + wl.locationString
      case _                 => message
    }
    msg + messageSuffix
  }

  def messageSuffix: String = {
    ""
  }
}
