package org.mule.weave.v2.parser.phase.metrics

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResourceResolver

class ResourceMetrics(val nameIdentifier: NameIdentifier, resourceResolver: WeaveResourceResolver) {
  val time: TimeMetric = new TimeMetric();
  var size: Int = 0

  def startFetch(): Unit = {
    time.start()
  }

  def endFetch(size: Int): Unit = {
    this.size = size
    time.end()
  }

  def print(): Unit = {
    println(s"|- [${nameIdentifier}] [${resourceResolver.getClass.getSimpleName}] took ${time.duration()}ms [size: ${size}]")
  }
}
