package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.TypeType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeReferenceResolver
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

class TypeNodeTypeResolver(typeReferenceResolver: WeaveTypeReferenceResolver) extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val weaveType = TypeType(WeaveType(node.astNode.asInstanceOf[WeaveTypeNode], typeReferenceResolver))
    Some(weaveType)
  }
}
