package org.mule.weave.v2.parser.ast.header

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode

case class Header(var directives: Seq[DirectiveNode]) extends AstNode {
  override def children(): Seq[AstNode] = directives
  override protected def doClone(): AstNode = {
    copy(directives.map(_.cloneAst()))
  }

  override def getKind(): String = DWAstNodeKind.HEADER
}
