package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.OnlyOneDefaultPattern
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.patterns.DefaultPatternNode
import org.mule.weave.v2.parser.ast.patterns.PatternMatcherNode

class PatternMatcherWithMoreThanOneDefaultValidation extends AstNodeVerifier {
  override def verify(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case PatternMatcherNode(lhs, patterns, _) => {
        val defaultPatternNodes: Seq[DefaultPatternNode] = patterns.patterns.collect({ case dp: DefaultPatternNode => dp })
        val size: Int = defaultPatternNodes.size
        if (size > 1) {
          defaultPatternNodes.foreach((df) => {
            context.messageCollector.error(OnlyOneDefaultPattern(), df.location())
          })
        }

      }
      case _ =>
    }
  }

}

