package org.mule.weave.v2.ts

import org.mule.weave.v2.parser.InvalidReferenceMessage
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.scope.Reference

object DefaultResolver extends ReferenceResolver {
  override def resolveVariable(typeGraphBuilder: TypeGraphBuilder, node: NameIdentifier, result: TypeNode, label: Option[EdgeLabel]): Unit = {
    val parsingContext = typeGraphBuilder.parsingContext

    parsingContext.notificationManager.progress()
    val reference: Option[Reference] = typeGraphBuilder.scope.resolveVariable(node)
    reference match {
      case Some(referenceNode) => {
        typeGraphBuilder.addReferenceEdge(referenceNode, result, label)
      }
      case _ => {
        val message = InvalidReferenceMessage(node)

        parsingContext.messageCollector.error(message, node.location())
      }
    }
  }

  override def cleanResolver(): ReferenceResolver = DefaultResolver
}
