package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.{ SelfImportingModule, UnableToResolveModule }
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.DoBlockNode
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode

class ImportsValidation[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware] extends VerificationPhase[T] {

  def checkImports(imports: Seq[ImportDirective], context: ParsingContext): Unit = {
    imports.map(_.importedModule.elementName).distinct.foreach((importedModuleName) => {
      //We ignore if we are importing the same file
      if (!context.nameIdentifier.equals(importedModuleName)) {
        val mayBeModule = context.tryToParseModule(importedModuleName)
        if (mayBeModule.isEmpty) {
          context.messageCollector.error(UnableToResolveModule(importedModuleName), importedModuleName.location())
        } else {
          context.messageCollector.mergeWith(mayBeModule.get.messages())
        }
      } else {
        context.messageCollector.error(SelfImportingModule(importedModuleName), importedModuleName.location())
      }
    })
  }

  override def verify(source: T, context: ParsingContext): Unit = {
    source.astNode match {
      case DocumentNode(header, _) => {
        checkImports(
          header.directives.collect({ case d: ImportDirective => d }),
          context)
      }
      case ModuleNode(_, nodes) => {
        checkImports(
          nodes.collect({ case d: ImportDirective => d }),
          context)
      }
      case DoBlockNode(header, _, _) =>
        checkImports(
          header.directives.collect({ case d: ImportDirective => d }),
          context)
      case _ =>
    }
  }
}