package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.TypeCoercedMessage
import org.mule.weave.v2.parser.TypeMismatch
import org.mule.weave.v2.ts.BooleanType
import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.FunctionType
import org.mule.weave.v2.ts.TypeCoercer
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

object ExpressionPatternTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val pattern: Edge = node.incomingEdges(EdgeLabels.PATTERN_EXPRESSION).head
    val caseExpression: Edge = node.incomingEdges(EdgeLabels.CASE_EXPRESSION).head
    val expression: Option[WeaveType] = FunctionCallNodeResolver.resolveReturnType(caseExpression.incomingType().asInstanceOf[FunctionType], Seq(pattern.incomingType()), Seq(), node, ctx)
    expression match {
      case Some(expressionReturnType) => {
        if (!TypeHelper.canBeAssignedTo(expressionReturnType, BooleanType(), ctx)) {
          if (TypeCoercer.coerce(BooleanType(), expressionReturnType, ctx).isEmpty)
            ctx.error(TypeMismatch(BooleanType(), expressionReturnType), caseExpression.source, expressionReturnType.location())
          else
            ctx.warning(TypeCoercedMessage(BooleanType(), expressionReturnType), caseExpression.source, expressionReturnType.location())
        }
      }
      case _ =>
    }
    val matchExpression: Edge = node.incomingEdges(EdgeLabels.MATCH_EXPRESSION).head
    val functionType: FunctionType = matchExpression.incomingType().asInstanceOf[FunctionType]
    FunctionCallNodeResolver.resolveReturnType(functionType, Seq(pattern.incomingType()), Seq(), node, ctx)
  }
}
