package org.mule.weave.v2.parser.phase.listener

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.CompilationPhase
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.sdk.WeaveResource
import org.mule.weave.v2.sdk.WeaveResourceResolver

trait ParsingNotificationListener {

  /**
    * Notifies that module compilation has started
    *
    * @param nameIdentifier The name identifier to be compiled
    */
  def startCompilation(nameIdentifier: NameIdentifier): Unit = {}

  /**
    * Notifies that the compilation has ended
    *
    * @param nameIdentifier The name of the module to be compiled
    * @param cached         If the compilation was cached
    * @param fromBinary     If the compilation was generated from a binary resource or source
    * @param result         The result
    */
  def endCompilation(nameIdentifier: NameIdentifier, cached: Boolean, fromBinary: Boolean, result: Option[Any]): Unit = {}

  /**
    * Notifies that a resource has finished
    *
    * @param nameIdentifier The name identifier
    * @param value          The phase
    * @param result         The phase result
    */
  def endPhase(nameIdentifier: NameIdentifier, value: CompilationPhase[_, _], result: PhaseResult[_]): Unit

  /**
    * Notifies that a parsing phase has statretd
    *
    * @param nameIdentifier The identifier of the element being parsed
    * @param value          The Phase
    */
  def startPhase(nameIdentifier: NameIdentifier, value: CompilationPhase[_, _]): Unit

  /**
    * Notifies that the resolution of a resource has been found
    *
    * @param nameIdentifier The name identifier to look for
    * @param result         The resource
    */
  def endResolvingResource(nameIdentifier: NameIdentifier, resourceResolver: WeaveResourceResolver, result: Option[WeaveResource]): Unit

  /**
    * Identifies that a resolution of a resource has been started
    *
    * @param nameIdentifier The name identifier of the resource
    */
  def startResolvingResource(nameIdentifier: NameIdentifier, resourceResolver: WeaveResourceResolver): Unit

  /**
    * Notifies that the parsing is still running
    */
  def progress(): Unit

}
