package org.mule.weave.v2.scope

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.ts.ScopeGraphTypeReferenceResolver

trait BaseVariableScope {
  val parsingContext: ParsingContext
  val name: Option[String]
  val astNode: AstNode
  val index: Int
  val declarations: Seq[NameIdentifier]
  val parentScope: Option[BaseVariableScope]
  val references: Seq[NameIdentifier]

  private lazy val navigator: AstNavigator = AstNavigator(astNode)

  /**
    * Returns the Variables scope that doesn't have a parent. It will check if this is the root if not it will go through its parent
    * @return The root scope
    */
  def rootScope(): BaseVariableScope

  def astNavigator(): AstNavigator = rootScope().navigator

  def moduleName(): NameIdentifier = parsingContext.nameIdentifier

  def resolveVariable(name: NameIdentifier): Option[Reference]

  def resolveLocalVariable(name: NameIdentifier): Option[Reference]

  def asVariableScope: VariableScope

  def collectLocalVariables(collector: Reference => Boolean): Seq[Reference]

  def scopesNavigator(): ScopesNavigator

  def referenceResolver(): ScopeGraphTypeReferenceResolver

  def isRootScope(): Boolean

  def children(): Seq[VariableScope]

  def resolveLocalReferenceTo(nameIdentifier: NameIdentifier): Seq[Reference]

  def resolveReferenceTo(nameIdentifier: NameIdentifier): Seq[Reference]

  def shadowedVariables(): Seq[NameIdentifier]

  def visibleVariables: Seq[Reference]

  /**
    * This method returns a copy of the reference with the moduleSource added
    */
  protected def toAbsoluteReference(maybeReference: Option[Reference], moduleIdentifier: NameIdentifier): Option[Reference] = {
    maybeReference.map((ref: Reference) => ref.copy(moduleSource = Some(moduleIdentifier)))
  }
}

