package org.mule.weave.v2.scope

import org.mule.weave.v2.parser.ast.header.directives._
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.utils.LazyValRef

class BinaryModuleVariableScopeFactory(context: ParsingContext) {
  def create(moduleNode: ModuleNode): BinaryModuleVariableScope = {
    val scope = VariableScopeBuilder(context, moduleNode.name.name, moduleNode)
    moduleNode.elements.foreach(x => visitNode(x, scope))
    scope.buildBinaryModule()
  }

  private def visitNode(directive: DirectiveNode, scope: VariableScopeBuilder): Unit = {
    directive match {
      case id: ImportDirective =>
        val lazyScope = LazyValRef(() => context.getRootVariableScopeForModule(id.importedModule.elementName).get)
        scope.addLazyImportedModule(id, lazyScope)
      case vd: VarDirective            => scope.addDeclaration(vd.variable)
      case td: TypeDirective           => scope.addDeclaration(td.variable)
      case id: InputDirective          => scope.addDeclaration(id.variable)
      case ad: AnnotationDirectiveNode => scope.addDeclaration(ad.nameIdentifier)
      case nd: NamespaceDirective      => scope.addDeclaration(nd.prefix)
      case fdn: FunctionDirectiveNode  => scope.addDeclaration(fdn.variable)
      case _                           =>
    }
  }
}

