package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.LiteralExpressionValueAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class NumberNode(literalValue: String, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends LiteralExpressionValueAstNode {
  override protected def doClone(): AstNode = copy(literalValue, codeAnnotations.map(_.cloneAst()))

  override def children(): Seq[AstNode] = codeAnnotations

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.NUMBER_NODE
}
