package org.mule.weave.v2.parser.phase.listener

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.CompilationPhase
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.sdk.WeaveResource
import org.mule.weave.v2.sdk.WeaveResourceResolver

import scala.collection.mutable

class ParsingNotificationManager {

  private val listeners = mutable.ArrayBuffer[ParsingNotificationListener]()

  def endPhase(nameIdentifier: NameIdentifier, value: CompilationPhase[_, _], result: PhaseResult[_]): Unit = {
    listeners.foreach((l) => {
      l.endPhase(nameIdentifier, value, result)
    })
  }

  def startPhase(nameIdentifier: NameIdentifier, value: CompilationPhase[_, _]): Unit = {
    listeners.foreach((l) => {
      l.startPhase(nameIdentifier, value)
    })
  }

  def addListener(listener: ParsingNotificationListener): ParsingNotificationManager = {
    listeners.+=(listener)
    this
  }

  def endResolvingResource(nameIdentifier: NameIdentifier, weaveResourceResolver: WeaveResourceResolver, result: Option[WeaveResource]): Unit = {
    listeners.foreach((l) => {
      l.endResolvingResource(nameIdentifier, weaveResourceResolver, result)
    })
  }

  def startResolvingResource(nameIdentifier: NameIdentifier, weaveResourceResolver: WeaveResourceResolver): Unit = {
    listeners.foreach((l) => {
      l.startResolvingResource(nameIdentifier, weaveResourceResolver)
    })
  }

  def progress(): Unit = {
    listeners.foreach((l) => {
      l.progress()
    })
  }

  def startCompilation(nameIdentifier: NameIdentifier): Unit = {
    listeners.foreach((l) => {
      l.startCompilation(nameIdentifier)
    })
  }

  def endCompilation(nameIdentifier: NameIdentifier, cached: Boolean, fromBinary: Boolean, result: Option[Any]): Unit = {
    listeners.foreach((l) => {
      l.endCompilation(nameIdentifier, cached, fromBinary, result)
    })
  }
}

