package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.BooleanType
import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

object ConditionalTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    // Conditional node has only one value edge
    Some(node.incomingEdges(EdgeLabels.VALUE).head.incomingType())
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    incomingExpectedType match {
      case Some(value) =>
        node.incomingEdges(EdgeLabels.CONDITION).map((_, BooleanType())) ++ node.incomingEdges(EdgeLabels.VALUE).map((_, value))
      case None => Seq()
    }
  }
}
