package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.NamespaceType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UriType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

class WeaveNamespaceTypeDirectiveResolver(prefix: String) extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val uriType: UriType = node.incomingEdges().head.incomingType().asInstanceOf[UriType]
    Some(NamespaceType(Some(prefix), Some(uriType)))
  }
}
