package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.exception.ParseTimeOutException
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationListener
import org.mule.weave.v2.sdk.WeaveResource
import org.mule.weave.v2.sdk.WeaveResourceResolver

class WatchdogParsingListener(maxTime: Long) extends ParsingNotificationListener {

  private val startTime = System.currentTimeMillis()

  override def endPhase(nameIdentifier: NameIdentifier, value: CompilationPhase[_, _], result: PhaseResult[_]): Unit = {
    failAfterTimeLimit(nameIdentifier.location())
  }

  override def startPhase(nameIdentifier: NameIdentifier, value: CompilationPhase[_, _]): Unit = {
    failAfterTimeLimit(nameIdentifier.location())
  }

  override def endResolvingResource(nameIdentifier: NameIdentifier, resourceResolver: WeaveResourceResolver, result: Option[WeaveResource]): Unit = {
    failAfterTimeLimit(nameIdentifier.location())
  }

  override def startResolvingResource(nameIdentifier: NameIdentifier, weaveResourceResolver: WeaveResourceResolver): Unit = {
    failAfterTimeLimit(nameIdentifier.location())
  }

  override def startCompilation(nameIdentifier: NameIdentifier): Unit = {
    failAfterTimeLimit(nameIdentifier.location())
  }

  override def endCompilation(nameIdentifier: NameIdentifier, cached: Boolean, fromBinary: Boolean, result: Option[Any]): Unit = {
    failAfterTimeLimit(nameIdentifier.location())
  }

  override def progress(): Unit = {
    failAfterTimeLimit(UnknownLocation)
  }

  private def failAfterTimeLimit(location: Location): Unit = {
    val executionTime = System.currentTimeMillis() - startTime

    if ((System.currentTimeMillis() - startTime) > maxTime) {
      throw new ParseTimeOutException(executionTime, maxTime, location)
    }
  }
}
