package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Child

case class ConditionalNode(var value: AstNode, var cond: AstNode) extends AstNode {
  override def children(): Seq[AstNode] = Child(value, cond)

  override protected def doClone(): AstNode = copy(value.cloneAst(), cond.cloneAst())

  override def getKind(): String = DWAstNodeKind.CONDITIONAL_NODE
}
