package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.annotation.InjectedNodeAnnotation
import org.mule.weave.v2.parser.annotation.QuotedStringAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.LiteralExpressionValueAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class StringNode(var value: String, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends LiteralExpressionValueAstNode {
  override val literalValue: String = value

  override def children(): Seq[AstNode] = {
    codeAnnotations
  }

  override protected def doClone(): AstNode = copy(value, codeAnnotations.map(_.cloneAst()))

  def quotedBy(): Option[Char] = {
    val quotedStringAnnotation: Option[QuotedStringAnnotation] = annotation(classOf[QuotedStringAnnotation])
    quotedStringAnnotation.map(_.quoteChar)
  }

  def withQuotation(quotation: Char): StringNode = {
    annotate(QuotedStringAnnotation(quotation))
    this
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.STRING_NODE
}

object QuotedStringNode {
  def apply(value: String): StringNode = {
    val node = StringNode(value)
    node.annotate(QuotedStringAnnotation('"'))
    node
  }
}

object EmptyStringNode {
  def apply(): StringNode = {
    val stringNode = StringNode("")
    stringNode.annotate(InjectedNodeAnnotation())
    stringNode
  }
}
