package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.CanonicalPhaseCategory
import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.MessageKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.header.directives.OutputDirective
import org.mule.weave.v2.parser.ast.module.ModuleNode

class ValidModuleDirectivesValidator extends AstNodeTransformer {
  override def transform(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case mn: ModuleNode => {
        mn.directives.foreach {
          case od: OutputDirective => context.messageCollector.error(Message(MessageKind.INVALID_OUTPUT_DIRECTIVE_IN_MODULE_MESSAGE_KIND, "Output is not supported in a Module", CanonicalPhaseCategory), od.location())
          case id: InputDirective  => context.messageCollector.error(Message(MessageKind.INVALID_INPUT_DIRECTIVE_IN_MODULE_MESSAGE_KIND, "Input is not supported in a Module", CanonicalPhaseCategory), id.location())
          case _                   =>
        }
      }
      case _ =>
    }
  }
}
