package org.mule.weave.v2.scope

import org.mule.weave.v2.parser.ast.variables.NameIdentifier

case class Reference(referencedNode: NameIdentifier, scope: BaseVariableScope, moduleSource: Option[NameIdentifier] = None) {

  /**
    * True if this reference a local element
    *
    * @return
    */
  def isLocalReference: Boolean = moduleSource.isEmpty

  /**
    * True if this reference is pointing to another module
    *
    * @return
    */
  def isCrossModule: Boolean = moduleSource.nonEmpty

  /**
    * Returns the fully qualified name of this reference. This will name will contain the module part and the local name
    *
    * @return The fully qualified name
    */
  def fqnReferenceName: NameIdentifier = {
    if (moduleSource.isDefined) {
      moduleSource.get.child(referencedNode.name)
    } else {
      scope.moduleName().child(referencedNode.name)
    }
  }
}
